// Soundboard that plays 1 of 4 .wav files stored on the SD card based on 1 of
// 4 buttons pressed

#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"

// .wav files to play
const char *filenames[1] = { "/sd/Sandstorm.wav"
                            };

// Define button
DigitalIn button_1(p27);

// USB serial (tx, rx)
Serial pc(USBTX, USBRX);

// SD card
SDFileSystem sd(p11, p12, p13, p24, "sd");

// Audio out (DAC)
AnalogOut       DACout(p18);
wave_player     waver(&DACout);

// Play a .wav file
int playSound(int file_num) {

    FILE *file;

    // Open sound file for reading
    file = fopen(filenames[file_num], "r");
    if ( file == NULL ) {
        error("ERROR: Could not open file for reading!\n");
        return -1;
    }

    // Play the sound file
    pc.printf("Playing sound clip %i\r\n", (file_num + 1));
    waver.play(file);
    
    // Reset to beginning of file and close it
    fseek(file, 0, SEEK_SET);
    fclose(file);

    return 0;
}

int main() {

    // Use internal pull-up resistors
    button_1.mode(PullUp);

    pc.printf("\r\nHardware Soundboard\r\n");

    while(1) {

        // Figure out which button was pressed and play that file
        if ( button_1 == 0 ) {
            playSound(0);
        }

        // Wait 10ms before sampling the buttons again
        wait(0.01);
    }
}
