#include "mbed.h"

class Fuellstand{
    int grenze; //Wert unter welchem die Pumpe ON oder OFF sein soll
    int now;       //Aktueller Messwert
    public:
    //constructers
        Fuellstand(int,PinName, PinName, PinName, PinName,PinName);    //Konstruktor mit Schwellenwerteingabe bei fehler defaultwert
                          //p25p     p50p     p75p     p100p   pboden
    //methodes
        int wert();                 //gibt den aktuelle 1wert zurück in 25er Schritten
        
        bool activate();            //gibt an ob die Pumpe aus sein soll
        void setgrenze(int);    //um die grenze zu setzten
        
        void setboden(bool);        //Messungaktivieren
    private:
        void getnow();              //misst den Wert
        PinName pp25p;
        PinName pp50p;
        PinName pp75p;
        PinName pp100p;
        PinName ppboden;
};
    //constructers
Fuellstand::Fuellstand(int ober, PinName new25p, PinName new50p, PinName new75p, PinName new100p ,PinName newboden){   //Konstruktor mit Schwellenwerteingabe bei fehler defaultwert
    if(ober>0&&ober<100)    grenze=ober;
    else    grenze=80;
    pp25p=new25p;    //25%
    pp50p=new50p;
    pp75p=new75p;
    pp100p=new100p;
    ppboden=newboden;
}
    //methodes
void Fuellstand::getnow(){                      //misst den Wert
    DigitalIn DI25(pp25p);
    DigitalIn DI50(pp50p);
    DigitalIn DI75(pp75p);
    DigitalIn DI100(pp100p);
    if(DI25==1)  now=25;
    else    now=0;
    if(DI50==1)   now=50;
    if(DI75==1)   now=75;
    if(DI100==1)   now=100;
}
int Fuellstand::wert(){                         //gibt den aktuelle wert zurück in 25er Schritten
    getnow();
    return now;
}
bool Fuellstand::activate(){                    //gibt an ob die Pumpe aus sein soll
    getnow();
    if(now<=grenze)
        return true;
    else
        return false;
}
void Fuellstand::setgrenze(int newgrenze){      //um die grenze zu setzten
    grenze=newgrenze;
}
void Fuellstand::setboden(bool newbodenstate){  //um die 1 aktivieren zu setzten
    DigitalOut DOboden(ppboden);
    DOboden=newbodenstate;
}