#include "mbed.h"
Serial pc (USBTX,USBRX);
C12832_LCD lcd;

int main () {
    char timeString[20];
    pc.baud(115200);
    lcd.cls();
    lcd.set_contrast(30); // 0-63
    
    // setup time structure
    struct tm t;
    t.tm_sec = 00;    // 0-59
    t.tm_min = 21;    // 0-59
    t.tm_hour = 16;   // 0-23
    t.tm_mday = 21;   // 1-31
    t.tm_mon = 12;     // 0-11
    t.tm_year = 115;  // year since 1900
   
    // convert to timestamp 
    time_t secondsSince1970 = mktime(&t);
    pc.printf("Seconds since January 1, 1970: %d\r\n", secondsSince1970);

    // Set time and start RTC
    set_time(secondsSince1970);
     
   while(1) { 
        secondsSince1970 = time(NULL);            
        strftime(timeString, 20, "%H:%M:%S\r\n", localtime(&secondsSince1970));
        pc.printf("aktuelle Zeit = %s", timeString);
        lcd.locate(0,0);
        lcd.printf("aktuelle Zeit = %s", timeString);
            
        wait(1.0);
    }
}

