#include "mbed.h"
extern Serial pc;

//0x3FFD = CORDIC magnitude
//0x3FFE = Measured angle without dynamic angle error compensation
//0x3FFF = Measured angle with dynamic angle error compensation

//Chipselect = activ Low
//Vor jedem einzelnem Data muss steigende Flanke erzeugt werden
 
SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut cs1(p23);
DigitalOut cs2(p24);
//Adresse ANGLECOM = 0x3FFF 


class _as50
{
int Index;
unsigned int Sarray1[24];
unsigned int Sarray2[24];
unsigned int Laenge,Breite; //Länge und breite des rechteckigen Kanals in dem gemessen wird
Timer timer;

public: _as50() //Konstruktor
  {
    Index=24;//Arraygröße für schleifen
    spi.format(16,1); // heißt  16 Bit und //mode 1 -->CPOL=0, CPHA=1 heißt steigende Flanke
    spi.frequency(1000000); //10Mhz clock
    cs1 = 1; cs2= 1; //steigende Flanke --> anfangs (0 benötigt)
    InitFeld();
    Laenge=1;Breite=1; //Länge und Breite des Kanals in Meter
  }
  public: unsigned int Durchfluss(int welcher)
  {
      int durchfluss=0;
      if(welcher==1)
     {
          timer.start();
          while(timer.read()<=1) // 1 Sekunde lang Daten sammeln und dann mittelwert zurückgeben
          {
              durchfluss=Sensormittelwert(1);
          }
           timer.stop();timer.reset();     
     }
     if(welcher==2)
     {
          timer.start();timer.reset();
          while(timer.read()<=1) 
          {
              durchfluss=Sensormittelwert(2);
          }
           timer.stop();timer.reset();
     }
     return durchfluss*Laenge*Breite; //*Länge*Breite des Kanals pro sekunde --> physikalischer Durchfluss
  }
  unsigned int Sensormittelwert(int welcher)
  {
     if(welcher==1)
     {
         unsigned int Sensor1=Sensor(1);                    //pc.printf("Sensor1: %u ",Sensor1);
         unsigned int size1= Arraysize(Sarray1);            //pc.printf("size1: %u ",size1);
         AddField(1,Sensor1,size1);
         unsigned int Mittelwert1=Mittelwert(Sarray1);      //pc.printf("Mittelwert1: %u \r\n",Mittelwert1);
         return Mittelwert1; //*Lange*Breite pro sekunde --> Durchfluss
     }
     if(welcher==2)
     {
         unsigned int Sensor2=Sensor(2);                   //pc.printf("Sensor2: %u",Sensor2);
         unsigned int size2= Arraysize(Sarray2);           //pc.printf("size2: %u",size2);
         AddField(2,Sensor2,size2);
         unsigned int Mittelwert2=Mittelwert(Sarray2);     //pc.printf("Mittelwert2: %u \r\n",Mittelwert2);
         return Mittelwert2;  //*Lange*Breite pro sekunde --> Durchfluss
     }
     return 0; //Default
  }
  
  unsigned int Sensor(unsigned int welcher) //Sensorwerte auslesen
  {
        unsigned int whoami;
        
        if(welcher==1)
        {
            cs1 = 0; //select Sensor  1 setzen
         
            // Send 0x8f, the command to read the WHOAMI register
            whoami = spi.write(0x3FFE | (1<<14)); //Register auslesen    1<<um 14 //rüberschieben (1 heißt lesen 0 heißt schreiben)
            whoami &= ~(0xC000);
            wait(0.001); //mindestens 5ns delay vor Flanke 
            cs1 = 1; //deselect Sensor (0 setzen) 
        }
        if (welcher==2)
        {
            cs2 = 0; //select Sensor  1 setzen
         
            // Send 0x8f, the command to read the WHOAMI register
            whoami = spi.write(0x3FFE | (1<<14)); //Register auslesen    1<<um 14 //rüberschieben (1 heißt lesen 0 heißt schreiben)
            whoami &= ~(0xC000);
            wait(0.001); //mindestens 5ns delay vor Flanke 
            cs2 = 1; //deselect Sensor (0 setzen) 
        }
        whoami/=360;
    return whoami;
        
   }
   void InitFeld() //Alle Felder in Array auf 0 setzen
   {
    for(int i=0;i<Index;i++)
    {
        Sarray1[i]=0;
        Sarray2[i]=0;
    }
   }
  unsigned int Arraysize(unsigned int Sarray[]) //Felder mit Werten sind ungleich 0...liefert Anzahl der Felder mit Werten
   {
    int counter=0;
    for(int i=0;i<Index;i++)
    {
            if(Sarray[i]!=0)
            {
                counter++;
            }
    }
    return counter;
   }
   
  void AddField(unsigned int welcher,unsigned int wert,unsigned int gross) 
  {
    if(gross==(Index-1))  //Bevor Feld "out of index geht" --> alles 0 setzen
    {       
        InitFeld();
        if(welcher==1)
        Sarray1[0]=wert;
        if(welcher==2)
        Sarray2[0]=wert;
    }
    else //Fügt Sensordaten in Array ein
    {
            if (welcher==1)
            {
                Sarray1[gross]=wert;
            }
            if (welcher==2)
            {
                Sarray2[gross]=wert;
            }
    }
    
  }
  unsigned int Mittelwert(unsigned int Array[])  //Errechnet den Mittelwert der Arraydaten
  {
     unsigned int groesse=Arraysize(Array);
     if((groesse)==0)
     groesse=1;
     unsigned int value=0;
     for(int i=0;i<groesse;i++)
     {
         value+=Array[i]; //alle addieren
     }                         
     value/=groesse; //durch Anzahl
                                                  
     return value;
  }
};
