/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.

 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.

 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/

/******************************************************************************
 * Tested on NUCLEO-F401RE, LPCXpresso11U68, LPCXpresso824-MAX platform.
 *****************************************************************************/

#include "mbed.h"
#include "bild.h"   //Bilder mit einbinden

#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"
#include "DmTftRa8875.h"
#include "DmTouch.h"
#include "DmTpFt6x06.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/* Note that there are restrictions on which platforms that can use printf
   in combinations with the DmTftLibrary. Some platforms (e.g. LPC1549 LPCXpresso)
   use the same pins for USBRX/USBTX and display control. Printing will
   cause the display to not work. Read more about this on the display's notebook
   page. */
//#define log(...) printf(__VA_ARGS__)
#define log(...)

#if 1
/* Displays without adapter */
#define DM_PIN_SPI_MOSI   p5
#define DM_PIN_SPI_MISO   p6
#define DM_PIN_SPI_SCLK   p7
#define DM_PIN_CS_TOUCH   p8
#define DM_PIN_CS_TFT     p21
#define DM_PIN_CS_SDCARD  p14   // 23
#define DM_PIN_CS_FLASH   p10   // 24
#else
/* Displays with adapter */
#define DM_PIN_SPI_MOSI   p5
#define DM_PIN_SPI_MISO   p6
#define DM_PIN_SPI_SCLK   p7
#define DM_PIN_CS_TOUCH   p8
#define DM_PIN_CS_TFT     p21
#define DM_PIN_CS_SDCARD  p14   // 13
#endif

/******************************************************************************
 * Local variables
 *****************************************************************************/


/*********  TFT DISPLAY INIT *********/
DmTftIli9341 tft(p21, p22, p5, p6, p7);  /* DmTftIli9341(PinName cs, PinName dc, PinName mosi, PinName miso, PinName clk)  DM_TFT28_105 and DM_TFT28_116*/

/*********   TOUCH PANEL INIT  *********/

DmTouch touch(DmTouch::DM_TFT28_105, p5, p6, p7);

DigitalInOut csTouch(DM_PIN_CS_TOUCH, PIN_OUTPUT, PullUp, 1);
DigitalInOut csDisplay(DM_PIN_CS_TFT, PIN_OUTPUT, PullUp, 1);
DigitalInOut csSDCard(DM_PIN_CS_SDCARD, PIN_OUTPUT, PullUp, 1);
#ifdef DM_PIN_CS_FLASH
DigitalInOut csFlash(DM_PIN_CS_FLASH, PIN_OUTPUT, PullUp, 1);
#endif

/******************************************************************************
 * Global variables
 *****************************************************************************/

uint16_t x = 0;
uint16_t y = 0;
uint16_t w = tft.width();
uint16_t h = tft.height();

bool down=false;
time_t secondsSince1970;
char timeString[20];

/******************************************************************************
 * Local functions
 *****************************************************************************/

//Farben definieren
/*
#define RED     0xf800
#define GREEN   0x07e0
#define BLUE    0x001f
#define BLACK   0x0000
#define YELLOW  0xffe0
#define WHITE   0xffff
#define CYAN        0x07ff
#define BRIGHT_RED  0xf810
#define GRAY1       0x8410
#define GRAY2       0x4208
*/
#define Navy            0x000F      /*   0,   0, 128 */
#define DarkGreen       0x03E0      /*   0, 128,   0 */
#define DarkCyan        0x03EF      /*   0, 128, 128 */
#define Maroon          0x7800      /* 128,   0,   0 */
#define Purple          0x780F      /* 128,   0, 128 */
#define Olive           0x7BE0      /* 128, 128,   0 */
#define LightGrey       0xC618      /* 192, 192, 192 */
#define DarkGrey        0x7BEF      /* 128, 128, 128 */
#define Magenta         0xF81F      /* 255,   0, 255 */
#define Orange          0xFD20      /* 255, 165,   0 */
#define GreenYellow     0xAFE5      /* 173, 255,  47 */
#define Pink            0xF81F

//Ticker initialisieren
Ticker Tick;

//Globale Variablen
float a;
int msek;
int sek;
int min;
int stund;
int lsek;
int lmin;
int lstund;
bool mode;
bool lhilf=false;

//Funktionsaufruf des Tickersinterrupts der Stoppuhr
void zaehl()
{
    if(mode==true) {
        msek++;
        //msek in sek
        if(msek==100) {
            sek++;
            msek=0;

        }

        //sek in min
        if(sek==60) {
            min++;
            sek=0;

        }

        //min in stund
        if(min==60) {
            stund++;
            min=0;
        }
        
        //stund reseten
        if(stund==24) {
            msek=0;
            sek=0;
            min=0;
            stund=0;
        }

    }

}

//"Falsche" Zwischenzeit stoppen
void lap()
{

    tft.drawNumber(78,250,stund,2,1);
    tft.drawString(94, 250, ":");
    tft.drawNumber(102,250,min,2,1);
    tft.drawString(118, 250, ":");
    tft.drawNumber(126,250,sek,2,1);
    tft.drawString(142, 250, ":");
    tft.drawNumber(150,250,msek,2,1);

}

//Stoppuhr reseten
void reset()
{
    msek=0;
    sek=0;
    min=0;
    stund=0;
    lap();
}

//Startseite zeichnen
void drawButtons()
{
    tft.clearScreen(BLACK);
//Rectangles
    tft.drawRectangle(25, 285, 74, 310,WHITE);
    tft.drawRectangle(95, 285, 144, 310,WHITE);
    tft.drawRectangle(165, 285,214, 310,WHITE);
    tft.fillRectangle(26, 286, 73, 309, GREEN);
    tft.fillRectangle(96, 286, 143, 309, RED);
//Text
    tft.drawString(84, 30, "STOPWATCH");
    tft.setTextColor(GREEN, BLACK);
    tft.drawString(30, 290, "START");
    tft.setTextColor(RED, BLACK);
    tft.drawString(104, 290, "STOP");
    tft.setTextColor(BLACK, WHITE);
    tft.drawString(170, 290, "RESET");
    touch.init();

    tft.drawImage(208,0,32,32,zahnrad);


}


//Einstellungen der RTC(Real Time Clock)
void RTC_SETUP()
{
    tft.clearScreen(BLACK);

    lhilf=true;

    tft.drawImage(176,0,64,32,accept);

    tft.drawImage(20,80,32,32,arrow_up);
    tft.drawImage(104,80,32,32,arrow_up);
    tft.drawImage(188,80,32,32,arrow_up);

    tft.drawImage(20,140,32,32,arrow_down);
    tft.drawImage(104,140,32,32,arrow_down);
    tft.drawImage(188,140,32,32,arrow_down);
    
    tft.drawString(84, 30, "SETTINGS");

    while(1) {
        secondsSince1970 = time(NULL);

        tft.drawNumber(28, 118,lstund,2,1);
        tft.drawNumber(112, 118, lmin,2,1);
        tft.drawNumber(196, 118, lsek,2,1);

        if(lstund==9&&lmin==1&&lsek==1&&lhilf==true)
        {
            //cages
            tft.drawImage(0,200,60,60,cage);
            tft.drawImage(60,200,60,60,cage);
            tft.drawImage(120,200,60,60,cage);
            tft.drawImage(180,200,60,60,cage);
            
            tft.drawImage(0,260,60,60,cage);
            tft.drawImage(60,260,60,60,cage);
            tft.drawImage(120,260,60,60,cage);
            tft.drawImage(180,260,60,60,cage);
            
            wait(2);
            
            tft.fillRectangle(0,200,240,320,BLACK);
            lhilf=false;
        }

        touch.readTouchData(x, y, down);
        if(down==true&&x>=208&&x<=240&&y>=0&&y<=32) {
            wait(0.25);
            drawButtons();
            return;
        }

        //Stunden Konfiguration
        if(down==true&&x>=20&&x<=52&&y>=80&&y<=112) {
            lstund++;
            if(lstund>=24)
                lstund=0;
            wait(0.25);
        }
        if(down==true&&x>=20&&x<=52&&y>=140&&y<=172) {
            lstund--;
            if(lstund<0)
                lstund=23;
            wait(0.25);
        }


        //Minuten Konfiguration
        if(down==true&&x>=104&&x<=136&y>=80&&y<=112) {
            lmin++;
            if(lmin>=60)
                lmin=0;
            wait(0.25);
        }
        if(down==true&&x>=104&&x<=136&&y>=140&&y<=172) {
            lmin--;
            if(lmin<0)
                lmin=59;
            wait(0.25);
        }


        //Sekunden Konfiguration
        if(down==true&&x>=188&&x<=220&&y>=80&&y<=112) {
            lsek++;
            if(lsek>=60)
                lsek=0;
            wait(0.25);
        }

        if(down==true&&x>=188&&x<=220&&y>=140&&y<=172) {
            lsek--;
            if(lsek<0)
                lsek=59;
            wait(0.25);
        }
        if(down==true&&x>=176&&x<=208&&y>=0&&y<=32) {
            struct tm t;
            t.tm_sec = lsek;    // 0-59
            t.tm_min = lmin;    // 0-59
            t.tm_hour = lstund;   // 0-23
            t.tm_mday = 29;   // 1-31
            t.tm_mon = 1;     // 0-11
            t.tm_year = 116;  // year since 1900


            // convert to timestamp
            time_t secondsSince1970 = mktime(&t);

            // Set time and start RTC
            set_time(secondsSince1970);

            wait(0.25);
            drawButtons();
            return;
        }


    }


}
/******************************************************************************
 * Main
 *****************************************************************************/

int main()
{


    struct tm t;
    t.tm_sec = 00;    // 0-59
    t.tm_min = 12;    // 0-59
    t.tm_hour = 10;   // 0-23
    t.tm_mday = 29;   // 1-31
    t.tm_mon = 1;     // 0-11
    t.tm_year = 116;  // year since 1900

    // convert to timestamp
    time_t secondsSince1970 = mktime(&t);

    // Set time and start RTC
    set_time(secondsSince1970);

    log("init tft \r\n");
    mode=false;
    tft.init();
    Tick.attach(&zaehl, 0.01);

    drawButtons();

    while (1) {
        secondsSince1970 = time(NULL);
        strftime(timeString, 20, "%H:%M:%S", localtime(&secondsSince1970));
        tft.drawString(90, 50, timeString);

        touch.readTouchData(x, y, down);

        if(down==true&&x>=208&&x<=240&&y>=0&&y<=32)
        {
            strftime(timeString, 20, "%H", localtime(&secondsSince1970));
            lstund=atoi(timeString);
            //atoi: Wandelt string in int um
            
            strftime(timeString, 20, "%M", localtime(&secondsSince1970));
            lmin=atoi(timeString);

            strftime(timeString, 20, "%S", localtime(&secondsSince1970));
            lsek=atoi(timeString);
            RTC_SETUP();
        }

        //Start Stoppuhr
        if(down==true&&x>=25&&x<=74&&y>=285&&y<=310) {
            if(mode==true) {
                lap();
            }
            mode=true;
        }
        //Stop Stoppuhr
        if(down==true&&x>=95&&x<=144&&y>=285&&y<=310)
            mode=false;
        //Reset Stoppuhr
        if(down==true&&x>=165&&x<=214&&y>=285&&y<=310)
            reset();

        tft.drawNumber(78,230,stund,2,1);
        tft.drawString(94, 230, ":");
        tft.drawNumber(102,230,min,2,1);
        tft.drawString(118, 230, ":");
        tft.drawNumber(126,230,sek,2,1);
        tft.drawString(142, 230, ":");
        tft.drawNumber(150,230,msek,2,1);

        down=false;
    }

}