//libaries
#include "mbed.h"
#include "HIDScope.h"
#include "encoder.h"
#include "MODSERIAL.h"


// globale variables
Ticker AInTicker;           //We make a ticker named AIn (use for HIDScope)

Ticker Treecko;             //We make a awesome ticker for our control system
AnalogIn potMeter2(A1);     //Analoge input of potmeter 2 (will be use for te reference position)
PwmOut M1E(D6);             //Biorobotics Motor 1 PWM control of the speed 
DigitalOut M1D(D7);         //Biorobotics Motor 1 diraction control

double pi = 3.14159265359;
double q1 = (pi/2);    //Reference position hoek 1 in radiance
double q2 = -(pi/2);   //Reference position hoek 2 in radiance
const double L1 = 0.30;        //Length arm 1 in mm
const double L2 = 0.38;        //Length arm 2 in mm
double B1 = 1;          //Friction constant motor 1
double B2 = 1;          //Friction constant motor 2
double K = 1;           //Spring constant movement from end-effector position to setpoint position
double Tijd = 1;           //Timestep value
double Rsx = 0.38;       //Reference x-component of the setpoint radius
double Rsy = 0.30;       //Reference y-component of the setpoint radius
double refP = 0;      //Reference position motor 1
double refP2 = 0.5*pi; //Reference position motor 2
double Rex = cos(q1)*L1 - sin(q2)*L2;   //The x-component of the end-effector radius 
double Rey = sin(q1)*L1 + cos(q2)*L2;   //The y-component of the end-effector radius
double R1x = 0;                         //The x-component of the joint 1 radius
double R1y = 0;                         //The y-component of the joint 1 radius
double R2x = cos(q1)*L1;                //The x-component of the joint 2 radius
double R2y = sin(q1)*L1;                //The y-component of the joint 1 radius   
double Fx = 0;
double Fy = 0;
double Tor1 = 0;
double Tor2 = 0;
double w1= 0;
double w2= 0;
bool automode = false;

Encoder motor1(D13,D12,true);
MODSERIAL pc(USBTX,USBRX);

float PwmPeriod = 1.0/5000.0;           //set up of PWM periode (5000 Hz, want 5000 periodes in 1 seconde)
const float Ts = 0.1;                   // tickettijd/ sample time
float e_prev = 0; 
float e_int = 0;

//tweede motor
AnalogIn potMeter1(A2);
PwmOut M2E(D5);
DigitalOut M2D(D4);
Encoder motor2(D9,D8,true);
Ticker DubbelTreecko;

//motors
//float Huidigepositie2;
//float Huidigepositie;

float PwmPeriod2 = 1.0/5000.0;           //set up of PWM periode (5000 Hz, want 5000 periodes in 1 seconde)
float e_prev2 = 0; 
float e_int2 = 0;

void RKI()
{
    Rex = cos(q1)*L1 - sin(q2)*L2;
    Rey = sin(q1)*L1 + cos(q2)*L2;
    R2x = cos(q1)*L1;
    R2y = sin(q1)*L1;
    Fx = (Rsx-Rex)*K;
    Fy = (Rsy-Rey)*K;
    Tor1 = (Rex-R1x)*Fy + (R1y-Rey)*Fx;
    Tor2 = (Rex-R2x)*Fy + (R2y-Rey)*Fx;
    w1 = Tor1/B1;
    w2 = Tor2/B2;
    q1 = q1 + w1*Tijd;
    q2 = q2 + w2*Tijd;
    
    int maxwaarde = 4096;                   // = 64x64
    refP = (((0.5*pi) - q1)/(2*pi))*maxwaarde;
    refP2 = (((0.5*pi) + q1 - q2)/(2*pi))*maxwaarde;    //Get reference positions
}

void SetpointRobot()
{   
    if automode == 0
    {
        for (int n = 0; n < 100; n++)
        {
            Rsy -= 0.002;
            RKI();
            // hier the control of the control system
            float Huidigepositie = Encoder(); 
            float error = (refP - Huidigepositie);// make an error
            float motorValue = FeedBackControl(error, e_prev, e_int);
            SetMotor1(motorValue);

            float Huidigepositie2 = Encoder2(); 
            float error2 = (refP2 - Huidigepositie2);// make an error
            float motorValue2 = FeedBackControl2(error2, e_prev2, e_int2);
            SetMotor2(motorValue2);
            //pc.printf("encoder 2 = %f\r\n",Huidigepositie2);
            pc.printf("refP2 = %f, Huidigepositie2 = %f, error = %f, motorValue2 = %f \r\n", refP2, Huidigepositie2, error2, motorValue2);
        }
        
        for (int n = 0; n < 100; n++)
        {
            Rsy += 0.002;
            RKI();
            // hier the control of the control system
            float Huidigepositie = Encoder(); 
            float error = (refP - Huidigepositie);// make an error
            float motorValue = FeedBackControl(error, e_prev, e_int);
            SetMotor1(motorValue);

            float Huidigepositie2 = Encoder2(); 
            float error2 = (refP2 - Huidigepositie2);// make an error
            float motorValue2 = FeedBackControl2(error2, e_prev2, e_int2);
            SetMotor2(motorValue2);
            //pc.printf("encoder 2 = %f\r\n",Huidigepositie2);
            pc.printf("refP2 = %f, Huidigepositie2 = %f, error = %f, motorValue2 = %f \r\n", refP2, Huidigepositie2, error2, motorValue2);
        }
        
        for (int n = 0; n < 100; n++)
        {
            Rsx += 0.002;
            RKI();
            // hier the control of the control system
            float Huidigepositie = Encoder(); 
            float error = (refP - Huidigepositie);// make an error
            float motorValue = FeedBackControl(error, e_prev, e_int);
            SetMotor1(motorValue);

            float Huidigepositie2 = Encoder2(); 
            float error2 = (refP2 - Huidigepositie2);// make an error
            float motorValue2 = FeedBackControl2(error2, e_prev2, e_int2);
            SetMotor2(motorValue2);
            //pc.printf("encoder 2 = %f\r\n",Huidigepositie2);
            pc.printf("refP2 = %f, Huidigepositie2 = %f, error = %f, motorValue2 = %f \r\n", refP2, Huidigepositie2, error2, motorValue2);
        }
    
        for (int n = 0; n < 100; n++)
        {
            Rsx -= 0.002;
            RKI()
            // hier the control of the control system
            float Huidigepositie = Encoder(); 
            float error = (refP - Huidigepositie);// make an error
            float motorValue = FeedBackControl(error, e_prev, e_int);
            SetMotor1(motorValue);

            float Huidigepositie2 = Encoder2(); 
            float error2 = (refP2 - Huidigepositie2);// make an error
            float motorValue2 = FeedBackControl2(error2, e_prev2, e_int2);
            SetMotor2(motorValue2);
            //pc.printf("encoder 2 = %f\r\n",Huidigepositie2);
            pc.printf("refP2 = %f, Huidigepositie2 = %f, error = %f, motorValue2 = %f \r\n", refP2, Huidigepositie2, error2, motorValue2);
        }
    
        automode = 1;
    }
    
    else automode = 1
    {
        double Potmeterwaarde2 = potMeter2.read();
        double Potmeterwaarde1 = potMeter1.read();
    
        if  (Potmeterwaarde2>0.6) {
            Rsx += 0.001;                    //het gaat telkens 1 mm verder wanneer de potmeter boven de 0.6 staat
        }
        else if  (Potmeterwaarde2<0.4) {
            Rsx -= 0.001;                    //het gaat telkens 1 mm terug wanneer de potmeter onder de 0.4 staat
        }
        else {                               //de x-waarde van de setpoint verandert niet
        }

        if (Potmeterwaarde1>0.6) {           //het gaat telkens 1 mm verder wanneer de potmeter boven de 0.6 staat
            Rsy += 0.001;
        }
        else if (Potmeterwaarde1<0.4) {      //het gaat telkens 1 mm terug wanneer de potmeter onder de 0.4
            Rsy -= 0.001;                       
        }
        else {                               //de y-waarde van de setpoint verandert niet
        }
    }
}
    
float FeedBackControl(float error, float &e_prev, float &e_int)   // schaalt de snelheid naar de snelheid zodat onze chip het begrijpt (is nog niet in werking)
{
    float kp = 0.001;                               // kind of scaled.
    float Proportional= kp*error;
    
    float kd = 0.0004;                           // kind of scaled. 
    float VelocityError = (error - e_prev)/Ts; 
    float Derivative = kd*VelocityError;
    e_prev = error;
    
    float ki = 0.0005;                           // kind of scaled.
    e_int = e_int+Ts*error;
    float Integrator = ki*e_int;
    
    
    float motorValue = Proportional + Integrator + Derivative;
    return motorValue;
}

float FeedBackControl2(float error2, float &e_prev2, float &e_int2)   // schaalt de snelheid naar de snelheid zodat onze chip het begrijpt (is nog niet in werking)
{
    float kp2 = 0.001;                             // kind of scaled.
    float Proportional2= kp2*error2;
    
    float kd2 = 0.001;                           // kind of scaled. 
    float VelocityError2 = (error2 - e_prev2)/Ts; 
    float Derivative2 = kd2*VelocityError2;
    e_prev2 = error2;
    
    float ki2 = 0.005;                           // kind of scaled.
    e_int2 = e_int2+Ts*error2;
    float Integrator2 = ki2*e_int2;
    
    
    float motorValue2 = Proportional2 + Integrator2 + Derivative2;
    return motorValue2;
}


void SetMotor1(float motorValue)
{
    if (motorValue >= 0)
    {
        M1D = 0;
    }
    else 
    {
        M1D = 1;
    }

    if  (fabs(motorValue) > 1)    
    {
        M1E = 1;                    //de snelheid wordt teruggeschaald naar 8.4 rad/s (maximale snelheid, dus waarde 1)
    }
    else
    {    
        M1E = fabs(motorValue);      //de absolute snelheid wordt bepaald, de motor staat uit bij een waarde 0
    }
}

void SetMotor2(float motorValue2)
{
    if (motorValue2 >= 0)
    {
        M2D = 1;
    }
    else 
    {
        M2D =0;
    }

    if  (fabs(motorValue2) > 1)    
    {
        M2E = 1;                    //de snelheid wordt teruggeschaald naar 8.4 rad/s (maximale snelheid, dus waarde 1)
    }
    else
    {    
        M2E = fabs(motorValue2);      //de absolute snelheid wordt bepaald, de motor staat uit bij een waarde 0
    }
}

float Encoder ()
{
    float Huidigepositie = motor1.getPosition ();
    return Huidigepositie;             // huidige positie = current position
}

float Encoder2 ()
{
    float Huidigepositie2 = motor2.getPosition ();
    return Huidigepositie2;             // huidige positie = current position
}

void MeasureAndControl(void)
{
    SetpointRobot(); 
    // RKI aanroepen
    RKI();
    
    // hier the control of the control system
    float Huidigepositie = Encoder(); 
    float error = (refP - Huidigepositie);// make an error
    float motorValue = FeedBackControl(error, e_prev, e_int);
    SetMotor1(motorValue);

    float Huidigepositie2 = Encoder2(); 
    float error2 = (refP2 - Huidigepositie2);// make an error
    float motorValue2 = FeedBackControl2(error2, e_prev2, e_int2);
    SetMotor2(motorValue2);
    //pc.printf("encoder 2 = %f\r\n",Huidigepositie2);
    pc.printf("refP2 = %f, Huidigepositie2 = %f, error = %f, motorValue2 = %f \r\n", refP2, Huidigepositie2, error2, motorValue2);
}

int main()
{
    M1E.period(PwmPeriod);
    Treecko.attach(MeasureAndControl, Ts);   //Elke 1 seconde zorgt de ticker voor het runnen en uitlezen van de verschillende 
                                            //functies en analoge signalen. Veranderingen worden elke 1 seconde doorgevoerd.
    pc.baud(115200);
     
    while(1) 
    {
        wait(0.2);
     //   pc.printf(" encoder 1 %f, encoder 2 %f\r\n",Huidigepositie,Huidigepositie2);
        
        //float B = motor1.getPosition();
        //float Potmeterwaarde = potMeter2.read();
        //float positie = B%4096;
       // pc.printf("pos: %f, \r\n pos2 = %f",motor1.getPosition(),motor2.getPosition); //potmeter uitlezen. tussen 0-1. voltage, dus *3.3V
    }
}
