#include "mbed.h"
#include "HIDScope.h"

HIDScope scope(2); // We're going to send 2 chennels of data
Ticker AInTicker;
//AnalogIn aIn1(A0);

AnalogIn potmeter2(A1);  //Analog input of the potmeter
AnalogIn but2(A2);
PwmOut E1(D6);          //Biorobotics Motor 1 PWM control speed 
PwmOut E2(D5);          //Biorobotics Motor 2 PWM control speed
DigitalOut M2(D4);      //Biorobotics Motor 2 direction control (bool)
DigitalOut M1(D7);      //Biorobotics Motor 1 direction control (bool)

float PwmPeriod = 1.0/5000.0;   //PWM period (5000 Hz)

volatile float x;
volatile float x_prev=0;
volatile float y; //filtered 'output' of ReadAnalogInAndFilter

void ReadAnalogInAndFilter()
{
    x=potmeter2; // Capture data
    scope.set(0,x); //store data in first element of scope memory
    y=(x_prev +x)/2.0; //averaging filter
    scope.set(1,y); // stor data in second element of scope memory
    x_prev=x; //Prepare for next round
    
    scope.send(); // send what's in the scope memory to PC
    
}

int main ()
{
    AInTicker.attach(&ReadAnalogInAndFilter, 0.01);
        
    E2.period(PwmPeriod);      //Set PWM period at 5000 Hz
    M2 = false;               // true is met de klok mee evenals false?
    
    while(true)
    {
        M2 = !M2;
        E2 = potmeter2.read();  //Set brightness of let (0,1)
        wait(5.0f);
    }
}