#include "mbed.h"
#include "HIDScope.h"
#include "encoder.h"
#include "MODSERIAL.h"


Ticker AInTicker;  //We maken een ticker aan genaamd AIn (wordt gebruikt voor HIDScope)

Ticker Treecko;                         //We maken een geweldige ticker aan zodat de potmeter en alles telkens opnieuw worden uitgelezen 
AnalogIn potMeter2(A1);               //Analoge input van potmeter 2 (zal gebruikt worden voor de snelheids bepaling van de motor)
AnalogIn potMeter1(A3);               //Analoge input van potmeter 1 (zal gebruikt worden voor de bepaling van de draairichting van de motor)
PwmOut M1E(D6);          //Biorobotics Motor 1 PWM controle van de snelheid 
DigitalOut M1D(D7);      //Biorobotics Motor 1 draairichting controle 
//gitalIn enc1ledB(D12);             //Led B van de encoder van motor 1
//gitalIn enc1ledA(D13);             //Led A van de encoder van motor 1

Encoder motor1(D13,D12,true);
MODSERIAL pc(USBTX,USBRX);



float PwmPeriod = 1.0/5000.0;           //PWM periode instellen (5000 Hz, want 5000 periodes in 1 seconde)

void SetMotor1(float motorValue)
{
    //Hiermee wordt de richting bepaald met behulp van potmeter 1 en wordt de snelheid bepaald aan de hand van de motorValue.
    if (potMeter1>= 0.5)
    {    //Counterclockwise rotation 
        M1D = 1;         //de motor draait tegen de klok in
    }
    else 
    {  
    //Clockwise rotation   
        M1D = 0;         //de motor draait met de klok mee
    }
    if  (fabs(motorValue) > 1)    
    {
        M1E = 1;         //de snelheid wordt teruggeschaald naar 8.4 rad/s (maximale snelheid, dus waarde 1)
    }
    else
    {    
        M1E = fabs(motorValue);      //de absolute snelheid wordt bepaald, de motor staat uit bij een waarde 0
    }
}

float GetReferenceVelocity()
{
    //Returns reference velocity in rad/s
    //Positieve waarden betekend met de klok mee draaien
    const float maxVelocity=8.4;        //in rad/s    
    float refV= potMeter2 * maxVelocity;    
    return refV;
}
        
float FeedForwardControl(float refV)   //Koppelt de referenceVelocity aan de motorValue
{
    //eenvoudige lineaire feed-forward control
    const float MotorGain = 8.4;        //eenheid: (rad/s) / PWM
    float motorValue = refV / MotorGain;   //bepalen van de fractie van de snelheid t.o.v. max snelheid
    return motorValue;
}

void MeasureAndControl(void)
{
    //Deze functie neemt de potmeter positie waar, leidt hier een referentie snelheid vanaf en controleert de motor 
    //met een eenvoudige feed-forward controller. Deze functie wordt aangeroepen met behulp van de ticker Treecko
    float Huidigepositie = motor1.getPosition();
    float Potmeterwaarde = potMeter2.read();
   
    if(Huidigepositie <= 4096)
    {
    int maxwaarde = 4096;
    float Potrefposition = Potmeterwaarde*maxwaarde;
    float kp = 50;
    float motorValue = kp*(Potrefposition - Huidigepositie);
    //float refV = GetReferenceVelocity();
    //float motorValue = FeedForwardControl(refV);
    SetMotor1(motorValue);
    }
    /* else
    {
        SetMotor1(0);
        }
        */
}

int main ()
{
      Treecko.attach(MeasureAndControl, 0.1);   //Elke 1 seconde zorgt de ticker voor het runnen en uitlezen van de verschillende 
                                            //functies en analoge signalen. Veranderingen worden elke 1 seconde doorgevoerd.

  while(1) {
      wait(0.2);
      pc.baud(115200);
  float B = motor1.getPosition();
    float Potmeterwaarde = potMeter2.read();
//    float positie = B%4096;
     pc.printf("pos: %d, speed %f, potmeter = %f V, \r\n",motor1.getPosition(), motor1.getSpeed(),(potMeter2.read()*3.3)); //potmeter uitlezen. tussen 0-1. voltage, dus *3.3V
  }
}