#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"

//Hidscope aanmaken
HIDScope scope(2);
//Ticker HIDinticker;
double maxi = 0.12;                                           // max signal after filtering, 0.1-0.12

// Biquad filters van respectievelijk Notch, High-pass en Low-pass filter
BiQuad N1( 8.63271e-01, -1.39680e+00, 8.63271e-01, -1.39680e+00, 7.26543e-01 );
BiQuadChain NF;
BiQuad HP1( 9.63001e-01, -9.62990e-01, 0.00000e+00, -9.62994e-01, 0.00000e+00 );
BiQuad HP2( 1.00000e+00, -2.00001e+00, 1.00001e+00, -1.96161e+00, 9.63007e-01 ); 
BiQuadChain HPF;
BiQuad LP1( 2.56971e-06, 2.56968e-06, 0.00000e+00, -9.72729e-01, 0.00000e+00 );
BiQuad LP2( 1.00000e+00, 2.00001e+00, 1.00001e+00, -1.97198e+00, 9.72734e-01 );
BiQuadChain LPF;

float f = 500;       // frequency
float dt = 1/f;      // sample frequency
Ticker emgverwerkticker;
AnalogIn emg(A0);   // EMG lezen

void emgverwerk ()
{
    double emgNotch = NF.step(emg.read() );  // Notch filter
    double emgHP = HPF.step(emgNotch);       // High-pass filter: also normalises around 0.
    double emgAbsHP = abs(emgHP);            // Take absolute value
    double emgLP = LPF.step(emgAbsHP);       // Low-pass filter: creates envelope
    double emgMax = maxi;                      //(emgLP);             // moet waarde 'schatten' voor de max, want je leest de data live. voorbeeld: 0.1, maar mogelijk 0.2 kiezen voor veiligheidsfactor. Dan gaat motor alleen maximaal op 1/2 vermogen.
    double emgFiltered = emgLP/emgMax;       // Scale to maximum signal: useful for motor
    if (emgFiltered >1)
    {
        emgFiltered=1.00;
    }
    scope.set(0,emgFiltered);
    scope.set(1,emg.read());
    scope.send();    
}    
/*
void ReadFilteredSignal(int emgF )
{
    scope.set(0,emgF);
    scope.send();                       //send what's in the scope memory to PC    
}
*/
int main()
{
    NF.add( &N1 );
    HPF.add( &HP1 ).add( &HP2 );
    LPF.add( &LP1 ).add( &LP2 );
    emgverwerkticker.attach(&emgverwerk,dt);
    //HIDinticker.attach(&ReadFilteredSignal(emgFiltered), 0.01);
    while(true)
    {
        }
    
    
}