#include "mbed.h"
#include "HIDScope.h"

//Define objects
AnalogIn    emg0( A0 );     //Dit zijn de EMG signalen die binnen komen, bv. de ground en een signaal
//AnalogIn    emg1( A1 );

Ticker      sample_timer;   //Leest de analog input en verplaatst deze naar de HIDScope
HIDScope    scope( 1 );
DigitalOut  led(LED1);


/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    //scope.set(1, emg1.read() );
 
    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}

int main()
{   
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    sample_timer.attach(&sample, 0.002);            //Elke 0.002 seconde wordt er dus een signaal gegeven aan de HIDScope. Je kunt met deze ticker dus 250Hz als maximale frequentie (range) meten (want anderss aliasing). 

    /*empty loop, sample() is executed periodically*/
    while(1) {}
}