//libaries
#include "mbed.h"
#include "encoder.h"
#include "MODSERIAL.h"

// globale variables
Ticker Treecko;                 //We make a awesome ticker for our control system
const float Ts = 0.1;                   // tickettijd/ sample time
MODSERIAL pc(USBTX,USBRX);
float PwmPeriod = 1.0/5000.0;   //set up of PWM periode (5000 Hz, want 5000 periodes in 1 seconde)
AnalogIn potMeter2(A1);         //Analoge input of potmeter 2 (will be use for te reference position)
AnalogIn potMeter1(A2);
DigitalIn Knopje1 (PTA4);       //tijdelijk
DigitalIn Knopje2 (PTC6);       //tijdelijk
bool autodemo_done = 1;         //automatische demo stand =0

//eerste motor
PwmOut M1E(D6);             //Biorobotics Motor 1 PWM control of the speed 
DigitalOut M1D(D7);         //Biorobotics Motor 1 diraction control
Encoder motor1(D13,D12,true);

float e_prev = 0; 
float e_int = 0;
float error1;

//tweede motor
PwmOut M2E(D5);
DigitalOut M2D(D4);
Encoder motor2(D9,D8,true);


float e_prev2 = 0; 
float e_int2 = 0;
float error2;

//RKI
double pi = 3.14159265359;
double q1 = (pi/2);    //Reference position hoek 1 in radiance
double q2 = -(pi/2);   //Reference position hoek 2 in radiance
const double L1 = 0.30;        //Length arm 1 in mm
const double L2 = 0.38;        //Length arm 2 in mm
double B1 = 1;          //Friction constant motor 1
double B2 = 1;          //Friction constant motor 2
double K = 1;           //Spring constant movement from end-effector position to setpoint position
double Tijd = 1;           //Timestep value
double Rsx = 0.38;       //Reference x-component of the setpoint radius
double Rsy = 0.30;       //Reference y-component of the setpoint radius
double Motor1Set = 0;      //Reference position motor 1
double Motor2Set = 0.5*pi; //Reference position motor 2
double Rex = cos(q1)*L1 - sin(q2)*L2;   //The x-component of the end-effector radius 
double Rey = sin(q1)*L1 + cos(q2)*L2;   //The y-component of the end-effector radius
double R1x = 0;                         //The x-component of the joint 1 radius
double R1y = 0;                         //The y-component of the joint 1 radius
double R2x = cos(q1)*L1;                //The x-component of the joint 2 radius
double R2y = sin(q1)*L1;                //The y-component of the joint 1 radius   
double Fx = 0;
double Fy = 0;
double Tor1 = 0;
double Tor2 = 0;
double w1=0;
double w2=0;

void RKI()
{
    Rex = cos(q1)*L1 - sin(q2)*L2;
    Rey = sin(q1)*L1 + cos(q2)*L2;
    R2x = cos(q1)*L1;
    R2y = sin(q1)*L1;
    Fx = (Rsx-Rex)*K;
    Fy = (Rsy-Rey)*K;
    Tor1 = (Rex-R1x)*Fy + (R1y-Rey)*Fx;
    Tor2 = (Rex-R2x)*Fy + (R2y-Rey)*Fx;
    w1 = Tor1/B1;
    w2 = Tor2/B2;
    q1 = q1 + w1*Tijd;
    q2 = q2 + w2*Tijd;
    
    
    /*if (tau1 < 0.00001){
      tau1 = 0;
    }
    else {
        tau1 = tau1;}
    if (tau2 < 0.00001){
      tau2 = 0;
    }
    else{
        tau2 = tau2;}*/
    
    int maxwaarde = 4096;                   // = 64x64
    Motor2Set = (((0.5*pi) + q1 - q2)/(2*pi))*maxwaarde;
    Motor1Set = (((0.5*pi) - q1)/(2*pi))*maxwaarde;
    
    //Motor1Set = -(q1/(2*pi))*maxwaarde;           //Calculate the desired motor1 angle from the desired joint positions
    //Motor2Set = ((pi-q2-q1)/(2*pi))*maxwaarde;   //Calculate the desired motor2 angle from the desired joint positions

}

void SetpointRobot()
{   
    //double Potmeterwaarde2 = potMeter2.read();
    //double Potmeterwaarde1 = potMeter1.read();
    bool knop1 = Knopje1;
    bool knop2 = Knopje2;

    if  (knop1 == false){        //(Potmeterwaarde2>0.6) {
        Rsx += 0.001;    // hoe veel verder gaat hij? 1 cm? 10 cm?
    }
    else if  (knop1 == true){  //(Potmeterwaarde2<0.4) {
                                //SetPx -= 0.001;
    }
    /*else
    {}*/
    if (knop2 == false){         //(Potmeterwaarde1>0.6) {
        Rsy += 0.001;
    }
    else if (knop2 ==true){    //(Potmeterwaarde1<0.4) {
                                //SetPy -= 0.001;
    }
    /*else
    {}*/
    //pc.printf("Setpointx = %f, Setpointy = %f \r\n", SetPx, SetPy);
}

/*float GetReferencePosition() 
{
    float Potmeterwaarde = potMeter2.read();
    int maxwaarde = 4096;                   // = 64x64
    float refP = Potmeterwaarde*maxwaarde;
    return refP;                            // value between 0 and 4096 
}

float GetReferencePosition2() 
{
    float Potmeterwaarde2 = potMeter1.read();
    int maxwaarde2 = 4096;                   // = 64x64
    float refP2 = Potmeterwaarde2*maxwaarde2;
    return refP2;                            // value between 0 and 4096 
}*/
    /*
float FeedBackControl(float error, float &e_prev, float &e_int)   // schaalt de snelheid naar de snelheid zodat onze chip het begrijpt (is nog niet in werking)
{
    float kp = 0.0005;                             // kind of scaled.
    float Proportional= kp*error;
    
    float kd = 0.0004;                           // kind of scaled. 
    float VelocityError = (error - e_prev)/Ts; 
    float Derivative = kd*VelocityError;
    e_prev = error;
    
    float ki = 0.00005;                           // kind of scaled.
    e_int = e_int+Ts*error;
    float Integrator = ki*e_int;
    
    
    float motorValue = Proportional + Integrator + Derivative;
    return motorValue;
}

float FeedBackControl2(float error2, float &e_prev2, float &e_int2)   // schaalt de snelheid naar de snelheid zodat onze chip het begrijpt (is nog niet in werking)
{
    float kp2 = 0.0005;                             // kind of scaled.
    float Proportional2= kp2*error2;
    
    float kd2 = 0.0004;                           // kind of scaled. 
    float VelocityError2 = (error2 - e_prev2)/Ts; 
    float Derivative2 = kd2*VelocityError2;
    e_prev2 = error2;
    
    float ki2 = 0.00005;                           // kind of scaled.
    e_int2 = e_int2+Ts*error2;
    float Integrator2 = ki2*e_int2;
    
    
    float motorValue2 = Proportional2 + Integrator2 + Derivative2;
    return motorValue2;
}


void SetMotor1(float motorValue)
{
    if (motorValue >= 0)
    {
        M1D = 0;                    //direction ...
    }
    else 
    {
        M1D = 1;                    //direction ...
    }

    if  (fabs(motorValue) > 1)    
    {
        M1E = 1;                    //de snelheid wordt teruggeschaald naar 8.4 rad/s (maximale snelheid, dus waarde 1)
    }
    else
    {    
        M1E = fabs(motorValue);      //de absolute snelheid wordt bepaald, de motor staat uit bij een waarde 0
    }
}

void SetMotor2(float motorValue2)
{
    if (motorValue2 >= 0)
    {
        M2D = 1; //PAS OP, DEZE MOET ZO ZIJN!
    }
    else 
    {
        M2D = 0;
    }

    if  (fabs(motorValue2) > 1)    
    {
        M2E = 1;                    //de snelheid wordt teruggeschaald naar 8.4 rad/s (maximale snelheid, dus waarde 1)
    }
    else
    {    
        M2E = fabs(motorValue2);      //de absolute snelheid wordt bepaald, de motor staat uit bij een waarde 0
    }
}

float Encoder ()
{
    float Huidigepositie = motor1.getPosition ();
    return Huidigepositie;             // huidige positie = current position
}

float Encoder2 ()
{
    float Huidigepositie2 = motor2.getPosition ();
    return Huidigepositie2;             // huidige positie = current position
}
*/
void MeasureAndControl(void)
{
    SetpointRobot(); 
    // RKI aanroepen
    RKI();
    /*
    // hier the control of the control system
    //float refP = GetReferencePosition(); 
    float Huidigepositie = Encoder(); 
    error1 = (Motor1Set - Huidigepositie);// make an error
    float motorValue = FeedBackControl(error1, e_prev, e_int);
    SetMotor1(motorValue);

    // hier the control of the control system
    //float refP2 = GetReferencePosition2(); 
    float Huidigepositie2 = Encoder2(); 
    error2 = (Motor2Set - Huidigepositie2);// make an error
    float motorValue2 = FeedBackControl2(error2, e_prev2, e_int2);
    SetMotor2(motorValue2);*/
}
/*
void Autodemo_or_demo()
{
    if (autodemo_done == 0)
    {
    SetPx = 0.38 + 0.15;
    SetPy = 0.30; 
    MeasureAndControl ();
    SetPx = 0.38;
    SetPy = 0.30; 
    MeasureAndControl ();   
    SetPx = 0.38;
    SetPy = 0.30 - 0.30; 
    MeasureAndControl ();
    SetPx = 0.38;
    SetPy = 0.30; 
    MeasureAndControl ();
    autodemo_done = 1;
    }
        
    else if (autodemo_done == 1)
    {
    SetpointRobot();
    MeasureAndControl ();
    }
    
}
*/

int main()
{
    M1E.period(PwmPeriod);
    Treecko.attach(&MeasureAndControl, Ts);   //Elke 1 seconde zorgt de ticker voor het runnen en uitlezen van de verschillende 
                                            //functies en analoge signalen. Veranderingen worden elke 1 seconde doorgevoerd.
    pc.baud(115200);
     
     
    while(1) 
    {
        //wait(0.2);
        //float B = motor1.getPosition();
        pc.printf("Setpointx = %f, Setpointy = %f, tau1 = %f, tau2 = %f, Motor1Set = %f, Motor2Set = %f,", Rsx, Rsy, Tor1, Tor2, Motor1Set, Motor2Set);
        pc.printf(" q1 = %f, q2 = %f \r\n", q1, q2);
        //float positie = B%4096;
        //pc.printf("pos: %d, speed %f, potmeter = %f V, \r\n",motor1.getPosition(), motor1.getSpeed(),(potMeter2.read()*3.3)); //potmeter uitlezen. tussen 0-1. voltage, dus *3.3V
        //pc.printf("q1 = %f, q2 = %f, Motor1Set = %f, Motor2Set = %f \r\n", q1, q2, Motor1Set, Motor2Set);   
    }
}
