#ifndef IIR_H
#define IIR_H

#include <vector>
using std::vector;
/*-----------------------------*/
//   Order of the numerator: m
//   Orser of the denominator: n
//--------------------------------//
//
//    y     gain*( sum(i from 0 to m) b[i]*x[k-i] )
//   --- = --------------------------------------------
//    u     1 + sum( i from 1 to n) a[i]*y[k-i]
//
//   y[k] = gain*( sum(i from 0 to m) b[i]*x[k-i] ) - sum( i from 1 to n) a[i]*y[k-i]
//
//   Compatible with the coefficient generated by Matlab fdatool
//
//   by C.F. Huang from LDSC
/*-----------------------------*/

class Circular_buffer{
private:
    size_t n;
    vector<float> A;
    // vector<float>::iterator it;
    int ind; // The index of the newest element

public:
    Circular_buffer();
    Circular_buffer(int n_in);
    //
    void Init(int n_in);
    //
    float Get(int i); // Get the value of the (t-i)th element, where t stands for the current sample
    void Insert(float x_new); // Pop the oldest element and push a new element
    void reset(float val); // Reset all elements to val
};

class IIR{
private:

    int m; // the order of numerator
    int n; // the order of denominator
    Circular_buffer x,y;
    vector<float> b; // parameters of numerator, highest order --> lowest order (newest -> oldest)
    vector<float> a; // parameters of denominator, highest order --> lowest order (newest -> oldest)
    float gain;

public:
    //
    IIR(int m, int n);
    //
    void Assign_parameters(float b_in[], float a_in[], float gain_in);
    //
    float Iterate_once(float x_in);
    void Reset(float val);
};

#endif
