/******************************************************************************/
/*                           This Nicleo is state 0                           */
/******************************************************************************/
#include "mbed.h"
#include "ColorMbed.h"

// Setting
int ifUrJirat = 1;

// Initail I/O.
AnalogIn VRx(A0);
AnalogIn VRy(A1);
DigitalIn Button(PA_4);
Serial bt(PA_15, PB_7);
Serial com(D1,D0);
ColorMbed dotmatrix;
Timer t;

// Initial function.
char posit2char(int posit);
char check_joys(int jx,int jy);
int IamWin();
int TellUrEnemy_uWin();
int char2posit(char cha);
int check_joys_int(int jx,int jy);
int check_correctPosition(int X,int Y);
int protect_ship(int head_position,int ship_type);
int get_ship_platform(int input_position,int ship_type);
void atk_enemy();
void enemy_atk();
void check_end();
void check_ready();
void mark_ship_destroyed();
void Select_Position(char M,int SetOrPlay);
void get_atk_platform(int atkpos);
void get_ship_UShipsRdestroyed();

//inessential
void print_ship_destroyed();
void print_enemy_platform();
void print_ship_platform();
void print_atk_platform();

// Nasarun's function.
int _power(int number , int power);
void hex_to_array(int* ar);
void place_ship3(char dir);
void array_to_hex(int ar1[8][8]);
void place_ship2_4(int ship,char dir);
void ch_same_position(int ar1[8][8],int ar2[8][8]);
void discard_same_position(int ar1[8][8],int ar2[8][8]);

// Initial variable.
int check_ship_underATK = 0;
int select_Position = 0;
int ATKposition = 0;
int enemy_ready = 0;
int check_ship1 = 0;
int check_ship2 = 0;
int check_win = 0;
int state = 0;
//Index.
int iShipType = 0;
int iWaitATK = 0;
int iGSU=0;
int iSUSPD = 0;
//Array
int ship_SelectType[8] = {4,3,2,2,1,1,1,1};
int enemy_platform[8][8] = {{0}};
int ship_platform[8][8] = {{0}}; //______________________________________________This is ship area.
int atk_platform[8][8] = {{0}};
int ship_underATK[15] = {9,9,9,9,9,9,9,9,9,9,9,9,9,9,9};
int ship_myShipsRdestroyed[15] = {9,9,9,9,9,9,9,9,9,9,9,9,9,9,9};
int ship_UShipsRdestroyed[15] = {9,9,9,9,9,9,9,9,9,9,9,9,9,9,9};
int ship_destroyed[8] = {0};
int ship4[4] = {0};
int ship3[3] = {0};
int ship2[2][2] = {{0}};
int ship1[4] = {0};
//fuction nasrun
int return_position[8][8] ;
int for_hex = 0;
int ch_post[8][8] = {{1,1,1,1,1,1,1,1},
                    {1,1,1,1,1,1,1,1},
                    {1,1,1,1,1,1,1,1},
                    {1,1,1,1,1,1,1,1},
                    {1,1,1,1,1,1,1,1},
                    {1,1,1,1,1,1,1,1},
                    {1,1,1,1,1,1,1,1},
                    {1,1,1,1,1,1,1,1}};
int return_hex[8];
int display_battle[8][8][3] = {0};
int _temppic[8] = {0x01,0x01,0x01,0x01,0,0,0,0};
int temppic2[8] = {0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
int temppic3[7][8] = {{0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00},{0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},{0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00}};
int temppic4[8] = {0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
int forshift[8] = {0};
int pic[8] = {0};
int i,j;
int check_boat3=0;
int check_hex=0;

// function Test!
int main(){ //-------------------------------------------------------------------Main Function.
    bt.baud(9600);
    float Vx;
    float Vy;
    int SW,iVxVy,iSW,n = 0;
    int uli = 0;
    char m;
    int rgb[3] = {60,0,0};
    int state_place_ship = 0;
    dotmatrix.init();
    t.start();
    while(1) {
        if(t.read()<0.4){
            dotmatrix.display_pic(_temppic,rgb);
        }
        else if(t.read() > 0.4 && t.read() < 0.8){
            dotmatrix.display_pic(pic,rgb);
        }
        else{
            t.reset();    
        }
        if(iShipType<8){
            Vx = VRx.read() * 1024;
            Vy = VRy.read() * 1024;
            SW = Button.read();
            m = check_joys(Vx,Vy);
            n = check_joys_int(Vx,Vy);
            if(n == 1){ //_______________________________________________________ For make sure coordinate is press 1 time.
                iVxVy = 0;
                check_ready();
            }
            if(SW == 1){ //______________________________________________________ For make sure switch is press 1 time.
                iSW = 0;
                check_ready();
            }
            if(m!=NULL && iVxVy==0){ //__________________________________________ Get position that wait for press switch.
                check_ready();
                Select_Position(m,0);
                if(state_place_ship == 0){
                    place_ship2_4(0,m); // 4
                }
                else if(state_place_ship == 1){
                    place_ship3(m);    // 3
                }
                else if(state_place_ship == 2){
                    place_ship2_4(1,m);    // 2
                }
                else if(state_place_ship == 3){
                    place_ship2_4(2,m);   //2
                }
                else if(state_place_ship == 4){
                    place_ship2_4(3,m);    // 1
                }
                else if(state_place_ship == 5){
                    place_ship2_4(4,m);    // 1
                }
                else if(state_place_ship == 6){
                    place_ship2_4(5,m);    // 1
                }
                else if(state_place_ship == 7){
                    place_ship2_4(6,m);    // 1
                }
                printf("select_Position = %d\n",select_Position);
                check_ready();
                iVxVy = 1;
                check_ready();
            }
            if(SW==0 && iSW==0){ //______________________________________________If switch pressing by human.
                printf("Wait!\n");
                
                check_ready();
                if(get_ship_platform(select_Position,ship_SelectType[iShipType])==0){ //__Please read explanation in function get_ship_platform.
                    printf("Please input correct position\n");
                }else{
                    iShipType++;
                    if(state_place_ship == 0){
                        for(j=0;j<8;j++){
                            pic[j] = temppic3[0][j]+pic[j];
                        }
                        for(j=0;j<8;j++){
                            _temppic[j] = temppic2[j]+pic[j];
                        }
                    }
                    else if(state_place_ship == 1){
                        for(j=0;j<8;j++){
                            pic[j] = temppic2[j]+pic[j];
                        }
                        for(j=0;j<8;j++){
                            _temppic[j] = temppic3[1][j]+pic[j];
                        }
                    }
                    else if(state_place_ship == 2){
                        for(j=0;j<8;j++){
                            pic[j] = temppic3[1][j]+pic[j];
                        }
                        for(j=0;j<8;j++){
                            _temppic[j] = temppic3[2][j]+pic[j];;   
                        }
                    }
                    else if(state_place_ship == 3){
                        for(j=0;j<8;j++){
                            pic[j] = temppic3[2][j]+pic[j];
                        }
                        for(j=0;j<8;j++){
                            _temppic[j] = temppic3[3][j]+pic[j];;   
                        }
                    }
                    else if(state_place_ship == 4){
                        for(j=0;j<8;j++){
                            pic[j] = temppic3[3][j]+pic[j];
                        }
                        for(j=0;j<8;j++){
                            _temppic[j] = temppic3[4][j]+pic[j];;   
                        }
                    }
                    else if(state_place_ship == 5){
                        for(j=0;j<8;j++){
                            pic[j] = temppic3[4][j]+pic[j];
                        }
                        for(j=0;j<8;j++){
                            _temppic[j] = temppic3[5][j]+pic[j];;   
                        }
                    }
                    else if(state_place_ship == 6){
                        for(j=0;j<8;j++){
                            pic[j] = temppic3[5][j]+pic[j];
                        }
                        for(j=0;j<8;j++){
                            _temppic[j] = temppic3[6][j]+pic[j];;   
                        }
                    }
                    else if(state_place_ship == 7){
                        for(j=0;j<8;j++){
                            pic[j] = temppic3[6][j]+pic[j];
                        }
                    }
                    state_place_ship = state_place_ship + 1;
                    select_Position = 0;
                }
                check_ready();
                iSW = 1;
                print_ship_platform();
                check_ready();
            }
        }else{
            if(enemy_ready!=1){
                printf("sent E\n");
                while(uli<50){
                    bt.printf("E");
                    uli++;
                }
            }else{
                bt.putc('l');
                printf("sent l\n");
            }
            printf("\n");
            break;
        }
    }
    if(enemy_ready == 0){
        printf("Wait for enemy ready\n");
        while(1){
            if(bt.readable()){
                if(bt.getc()=='l'){
                    break;
                }
            }
        }
        state = 0;
    }else{state = 1;}
    wait(5);
    while(1) { //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Play
        if(state == 0){
            printf("Your turn.\n");
            atk_enemy();
            printf("This is enemy_platform.\n");
            print_enemy_platform();
            state = 1;
        }else{
            printf("Wait for enemy attack.\n");
            enemy_atk();
            if(check_win==1){
                printf("BOO!! You Win!\n");
                break;
            }
            printf("This is atk_platform.\n");
            print_atk_platform();
            printf("This is ship_destroyed. : ");
            print_ship_destroyed();
            if(TellUrEnemy_uWin()==1){
                while(uli<100){
                    bt.putc('q');
                    uli++;
                }
                printf("BOO!! You lost!\n");
                break;
            }else{state = 0;}
        }
    }
    while(1){printf("END\n");wait(1);}
}

/******************************************************************************/
/*                                                                            */
/*                                                                            */
/*                              Another function                              */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

char check_joys(int jx,int jy){ //-----------------------------------------------Check joystick that it up,down,left or right.
    
    if(ifUrJirat==1){
        if(jx < 14.0){       return 'a';}
        else if(jx > 1010.0){return 'd';}
        else if(jy < 14.0){  return 'w';}
        else if(jy > 1010.0){return 's';}
        else{return NULL;}
    }else{
        if(jx < 14.0){       return 'd';}
        else if(jx > 1010.0){return 'a';}
        else if(jy < 14.0){  return 's';}
        else if(jy > 1010.0){return 'w';}
        else{return NULL;}
    }
}
int check_joys_int(int jx,int jy){ //--------------------------------------------Check joystick that it is centre.
    if(jx>=450.0&&jx<=600.0){
        if(jy>=450.0&&jy<=600.0){
            return 1;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}
void Select_Position(char M,int SetOrPlay){ //-------------------------------------------------Change position of cursor (Joystick).
    int protect_ships;
    protect_ships = protect_ship(select_Position,ship_SelectType[iShipType]);
    switch(M){
        case 'a':
            if(select_Position%10!=0){
                select_Position = select_Position - 1;
            }
            break;
        case 'd':
            if(select_Position%10!=7){
                if(SetOrPlay==1){
                    select_Position = select_Position + 1;
                }else{
                    if(protect_ships==1 or protect_ships==0){
                        select_Position = select_Position + 1;
                    }
                }
            }
            break;
        case 'w':
            if(select_Position/10!=0){
                select_Position = select_Position - 10;
            }
            break;
        case 's':
            if(select_Position/10!=7){
                if(SetOrPlay==1){
                    select_Position = select_Position + 10;
                }else{
                    if(protect_ships==1 or protect_ships==2){
                        select_Position = select_Position + 10;
                    }
                }
            }
            break;
    }
}
int protect_ship(int head_position,int ship_type){
    int x,y = 0;
    y = head_position/10;
    x = head_position%10;
    if(ship_type==4){if((y+4)>7){return 0;}else{return 1;}}
    else if(ship_type==3){if((x+3)>7){return 2;}else{return 1;}}
    else if(ship_type==2){if((y+2)>7){return 0;}else{return 1;}}
    else{return 1;}
}
int get_ship_platform(int input_position,int ship_type){ //-----------------------Plot ship in ship area.
    int i,x,y = 0;
    int error = 0;

    y = input_position/10;
    x = input_position%10;

    for(i=0;i<ship_type;i++){
        if(check_correctPosition(y,x) == 1){
            if(ship_type == 4){ship4[i] = (y*10)+x;}
            else if(ship_type == 3){ship3[i] = (y*10)+x;}
            else if(ship_type == 2){ship2[check_ship2][i] = (y*10)+x;}
            else if(ship_type == 1){ship1[check_ship1] = (y*10)+x;check_ship1++;}
        }else{error = 1;break;}
        if(ship_type%2 == 0){y++;}else{x++;}
    }
    if(ship_type==2){check_ship2++;}
    if(error == 1){return 0;}else{
        y = input_position/10;
        x = input_position%10;
        for(i=0;i<ship_type;i++){
            if(ship_type == 2 and check_ship2==1){
                ship_platform[y][x] = ship_type + 3;
            }else{ship_platform[y][x] = ship_type;}
            if(ship_type%2 == 0){y++;}else{x++;}
        }
        return 1;
    }
}
int check_correctPosition(int X,int Y){
    if(X<=7){
        if(Y<=7){
            if(ship_platform[X][Y] == 0){return 1;}else{return 0;}
        }else{return 0;}
    }else{return 0;}
}
void print_ship_platform(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            printf("| %d |",ship_platform[i][j]);
        }
        printf("\n");
    }
}
void print_enemy_platform(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            printf("| %d |",enemy_platform[i][j]);
        }
        printf("\n");
    }
}
void print_atk_platform(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            printf("| %d |",atk_platform[i][j]);
        }
        printf("\n");
    }
}
void print_ship_destroyed(){
    printf("{");
    for(int i=0;i<8;i++){
        printf("%d",ship_destroyed[i]);
        if(i!=14){printf(",");}
    }
    printf("}\n");
}
void check_ready(){
    if(bt.readable()){enemy_ready = 1;}
}
char posit2char(int posit){
    int as = posit+48;
    char ch = as;
    return ch ;
}
int char2posit(char cha){
    int as = cha;
    as = as-48;
    return as;
}
void get_atk_platform(int atkpos){
    int i,j,x,y = 0;

    x = atkpos/10;
    y = atkpos%10;
    
    if(ship_platform[x][y]!=0){
        if(atk_platform[x][y]==0){
            atk_platform[x][y] = ship_platform[x][y];
            printf("posit2char : %c\n",posit2char(atk_platform[x][y]));
            bt.putc(posit2char(atk_platform[x][y]));
            ship_underATK[check_ship_underATK] = atkpos;
            if(atk_platform[x][y]==4){
                for(i=0;i<4;i++){
                    for(j=0;j<15;j++){
                        if(ship4[i]==ship_underATK[j]){ship_destroyed[0]++;}
                    }
                }
            }else if(atk_platform[x][y]==3){
                for(i=0;i<3;i++){
                    for(j=0;j<15;j++){
                        if(ship3[i]==ship_underATK[j]){ship_destroyed[1]++;}
                    }
                }
            }else if(atk_platform[x][y]==5){
                for(i=0;i<2;i++){
                    for(j=0;j<15;j++){
                        if(ship2[0][i]==ship_underATK[j]){ship_destroyed[2]++;}
                    }
                }
            }else if(atk_platform[x][y]==2){
                for(i=0;i<2;i++){
                    for(j=0;j<15;j++){
                        if(ship2[1][i]==ship_underATK[j]){ship_destroyed[3]++;}
                    }
                }
            }else if(atk_platform[x][y]==1){
                for(i=0;i<4;i++){
                    for(j=0;j<15;j++){
                        if(ship3[i]==ship_underATK[j]){
                            ship_destroyed[4+i]++;
                            atk_platform[x][y] = 11;
                            ship_myShipsRdestroyed[iGSU] = atkpos;
                            iGSU++;
                        }
                    }
                }
            }
        }else{
            printf("You repeatedly attacked.\n");
        }
    }else{
        atk_platform[x][y] = 8;
        bt.putc(posit2char(atk_platform[x][y]));        
    }
    
    /*
    if(ship_platform[x][y]!=0  atk_platform[x][y]==0){
        atk_platform[x][y] = ship_platform[x][y];
        bt.putc(posit2char(atk_pla02tform[x][y]));
        ship_underATK[check_ship_underATK] = (x*10)+y;
        if(atk_platform[x][y]==4){
            for(i=0;i<4;i++){
                for(j=0;j<15;j++){
                    if(ship4[i]==ship_underATK[j]){ship_destroyed[0]++;}
                }
            }
        }else if(atk_platform[x][y]==3){
            for(i=0;i<3;i++){
                for(j=0;j<15;j++){
                    if(ship3[i]==ship_underATK[j]){ship_destroyed[1]++;}
                }
            }
        }else if(atk_platform[x][y]==2){
            for(i=0;i<4;i++){
                for(j=0;j<15;j++){
                    if(ship2[0][i]==ship_underATK[j]){ship_destroyed[2]++;}
                    if(ship2[1][i]==ship_underATK[j]){ship_destroyed[3]++;}
                }
            }
        }else if(atk_platform[x][y]==1){
            for(i=0;i<4;i++){
                for(j=0;j<15;j++){
                    if(ship3[i]==ship_underATK[j]){
                        ship_destroyed[4+i]++;
                        atk_platform[x][y] = 11;
                    }
                }
            }
        }
    }
    if(atk_platform[x][y]!=0){
        printf("You repeatedly attacked.\n");
    }else{
        atk_platform[x][y] = 8;
        bt.putc(posit2char(atk_platform[x][y]));
    }
    */
}
void get_ship_UShipsRdestroyed(){
    int ship[8] = {0};
    for(int k=0;k<2;k++){
        for(int i=0;i<8;i++){
            for(int j=0;j<8;j++){
                if(enemy_platform[i][j]==4){
                    if(k==0){ship[0]++;}
                    if(ship[4]==1){ship_UShipsRdestroyed[iSUSPD] = enemy_platform[i][j];}
                }
                else if(enemy_platform[i][j]==3){
                    if(k==0){ship[1]++;}
                    if(ship[5]==1){ship_UShipsRdestroyed[iSUSPD] = enemy_platform[i][j];}
                }
                else if(enemy_platform[i][j]==2){
                    if(k==0){ship[2]++;}
                    if(ship[6]==1){ship_UShipsRdestroyed[iSUSPD] = enemy_platform[i][j];}
                }
                else if(enemy_platform[i][j]==5){
                    if(k==0){ship[3]++;}
                    if(ship[7]==1){ship_UShipsRdestroyed[iSUSPD] = enemy_platform[i][j];}
                }
            }
        }
        if(ship[0]==4){ship[4]=1;}
        if(ship[1]==3){ship[5]=1;}
        if(ship[2]==2){ship[6]=1;}
        if(ship[3]==2){ship[7]=1;}
    }
}
void mark_ship_destroyed(){
    int i,j,k = 0;
    
    if(ship_destroyed[0]==10){
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                if(atk_platform[i][j]==4){atk_platform[i][j] = 11;ship_myShipsRdestroyed[iGSU] = (i*10)+j;iGSU++;}
            }
        }
    }
    if(ship_destroyed[1]==6){
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                if(atk_platform[i][j]==3){atk_platform[i][j] = 11;ship_myShipsRdestroyed[iGSU] = (i*10)+j;iGSU++;}
            }
        }
    }
    if(ship_destroyed[2]==3){
        for(k=0;k<2;k++){
            i = ship2[0][k]/10;
            j = ship2[0][k]%10;
            atk_platform[i][j] = 11;
            ship_myShipsRdestroyed[iGSU] = (i*10)+j;
            iGSU++;
        }
    }
    if(ship_destroyed[3]==3){
        for(k=0;k<2;k++){
            i = ship2[1][k]/10;
            j = ship2[1][k]%10;
            atk_platform[i][j] = 11;
            ship_myShipsRdestroyed[iGSU] = (i*10)+j;
            iGSU++;
        }
    }
}
void atk_enemy(){
    // comment for display : see only bomb and history of planting
    float Vx;
    float Vy;
    int SW,iVxVy,iSW,n = 0;
    char m;
    
    select_Position = 0;
    while(1){
        Vx = VRx.read() * 1024;
        Vy = VRy.read() * 1024;
        SW = Button.read();
        m = check_joys(Vx,Vy);
        n = check_joys_int(Vx,Vy);
        if(n == 1){ iVxVy = 0;}
        if(SW == 1){
            iSW = 0;
        }
        if(iSW == 1){
            if(bt.readable()){
                enemy_platform[select_Position/10][select_Position%10] = char2posit(bt.getc());
                break;
            }
        }
        if(m!=NULL and iVxVy==0){
            Select_Position(m,1);
            printf("select_Position = %d\n",select_Position);
            bt.putc(posit2char(select_Position));
            iVxVy = 1;
        }
        if(SW==0 && iSW==0){
            bt.putc('B');
            printf("You attacking at position %d\n",select_Position);
            iSW = 1;
        }
    }
}
void enemy_atk(){
    int data_fromEnemy;
    char replica_data_fromEnemy;
    select_Position = 0;
    while(1){
        if(bt.readable()){
            replica_data_fromEnemy = bt.getc();
            if(replica_data_fromEnemy!='q' and replica_data_fromEnemy!=8){
                data_fromEnemy = char2posit(replica_data_fromEnemy);
                if(data_fromEnemy!=18){
                    select_Position = data_fromEnemy;
                    printf("enemy select_Position = %d\n",select_Position);
                }else{
                    ATKposition = select_Position;
                    break;
                }
            }
            if(replica_data_fromEnemy=='q'){
                check_win = 1;
                break;
            }
        }
    }
    if(check_win!=1){
        printf("Enemy attack at your area %d\n",ATKposition);
        get_atk_platform(ATKposition);
        check_ship_underATK++;
        mark_ship_destroyed();
    }
}
int TellUrEnemy_uWin(){
    int sub_end = 0;
    
    for(int i=0;i<15;i++){
        if(ship_underATK[i]!=9){sub_end++;}
    }
    if(sub_end==15){return 1;}else{return 0;}
}
int IamWin(){
    char chare;
    if(bt.readable()){
        chare = bt.getc();
        if(chare=='q'){return 1;}else{return 0;}
    }else{return 0;}
}


























// ____________________________________________________________________________________________________________________________________Nasarun's function.

void hex_to_array(int* ar){
    int i;
    int j;
    int temp;
    for(i = 0;i<8;i++){
        temp = ar[i];
        for(j = 0;j<8;j++){
            if(0x80 & temp){
                return_position[i][j] = 1;
            }
            else{
                return_position[i][j] = 0;
            }
            temp = temp << 1;
        }
    }
}

void ch_same_position(int ar1[8][8],int ar2[8][8]){
    int i;
    int j;
    for(i = 0;i<8;i++){
        for(j = 0;j<8;j++){
            if(ar1[i][j] == 1 && ar2[i][j] == 1){
                ch_post[i][j] = 1;
            }
            else{
                ch_post[i][j] = 0;
            }
        }
    }

}

void discard_same_position(int ar1[8][8],int ar2[8][8]){
    int i;
    int j;
    for(i = 0;i<8;i++){
        for(j = 0;j<8;j++){
            if(ar1[i][j] == ch_post[i][j] && ar2[i][j] == ch_post[i][j] ){
                ar1[i][j] = 0;
                ar2[i][j] = 0;
            }
        }
    }
}


int _power(int number , int power){
  int i = 0;
  int number1 = number;
  if(power == 0){return 1;}
  for(i = 1 ; i <= power ; i++ ){
    if(power == 1){return number;}
    if(i == 1){number = number * 1;}
    else{number1 = number1 * number;}
  }
return number1;
}


void array_to_hex(int ar1[8][8]){
    int prompt;
    int i;
    int j;
    for(i = 0;i<8;i++){
        for(j = 0;j<8;j++){
            prompt = _power(2,7-j);
            if(ar1[i][j] == 1){
                for_hex = for_hex + prompt;
            }
            else{
                for_hex = for_hex + 0;
            }
        }
        return_hex[i] = for_hex;
        prompt = 0;
        for_hex = 0;
    }
}

void place_ship3(char dir){
    int post1[8][8] = {0};
    int post2[8][8] = {0};
    int hex_post1[8] = {0};
    int hex_post2[8] = {0};
    int hex_post_cut[8] = {0};
    int get_same_position[8][8];
    int wow=0;

    if(dir == 'w'&& temppic2[0] == 0){
        for(j=0;j<8;j++){
            if(j == 7){
                forshift[7] = 0;
            }
            else{
                forshift[j] = temppic2[j+1];
            }
        }
        for(j=0;j<8;j++){
            temppic2[j] = forshift[j];
            _temppic[j] = temppic2[j];
        }
        // begin to compare and combine two frame
        hex_to_array(_temppic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post1[i][j] = return_position[i][j];
            }
        }
        hex_to_array(pic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post2[i][j] = return_position[i][j];
            }
        }

        // begin to check boypeacemaker
        ch_same_position(post1,post2);
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                get_same_position[i][j] = ch_post[i][j];
                if(get_same_position[i][j] == 1){
                    wow = 1;
                }
            }
        }
        if(wow == 0){
            for(i=0;i<8;i++){_temppic[i] = temppic2[i]+pic[i];}
        }
        else{
            discard_same_position(post1,post2);
            array_to_hex(post1);
            for(i = 0;i<8;i++){
                hex_post1[i] = return_hex[i];
            }
            array_to_hex(post2);
            for(i = 0;i<8;i++){
                hex_post2[i] = return_hex[i];
            }
            array_to_hex(get_same_position);
            for(i = 0;i<8;i++){
                hex_post_cut[i] = return_hex[i];
            }
            for(i = 0;i<8;i++){
                _temppic[i] = hex_post1[i] + hex_post2[i] + hex_post_cut[i];
            }
        }
    }
    if(dir == 'd'){
        for(i=0;i<8;i++){
            if(temppic2[i] == 0xe0){
                check_boat3 = 1;
            }
        }
        if(check_boat3 == 0){
            for(j=0;j<8;j++){
                if(temppic2[j] != 0){
                    temppic2[j] = temppic2[j]*2;
                }
                else{
                    temppic2[j] = 0;
                }
                _temppic[j] = temppic2[j];
            }
            // begin to compare and combine two frame
            hex_to_array(_temppic);
            for(i = 0;i<8;i++){
                for(j = 0;j<8;j++){
                    post1[i][j] = return_position[i][j];
                }
            }
            hex_to_array(pic);
            for(i = 0;i<8;i++){
                for(j = 0;j<8;j++){
                    post2[i][j] = return_position[i][j];
                }
            }

            // begin to check boypeacemaker
            ch_same_position(post1,post2);
            for(i=0;i<8;i++){
                for(j=0;j<8;j++){
                    get_same_position[i][j] = ch_post[i][j];
                    if(get_same_position[i][j] == 1){
                        wow = 1;
                    }
                }
            }
            if(wow == 0){
                for(i=0;i<8;i++){_temppic[i] = temppic2[i]+pic[i];}
            }
            else{
                discard_same_position(post1,post2);
                array_to_hex(post1);
                for(i = 0;i<8;i++){
                    hex_post1[i] = return_hex[i];
                }
                array_to_hex(post2);
                for(i = 0;i<8;i++){
                    hex_post2[i] = return_hex[i];
                }
                array_to_hex(get_same_position);
                for(i = 0;i<8;i++){
                    hex_post_cut[i] = return_hex[i];
                }
                for(i = 0;i<8;i++){
                    _temppic[i] = hex_post1[i] + hex_post2[i] + hex_post_cut[i];
                }
            }
        }
        check_boat3 = 0;
    }
    if(dir == 'a'){
        for(i=0;i<8;i++){
            if(temppic2[i] == 0x07){
                check_boat3 = 1;
            }
        }
        if(check_boat3 == 0){
            for(j=0;j<8;j++){
                if(temppic2[j] != 0){
                    temppic2[j] = temppic2[j]/2;
                }
                else{
                    temppic2[j] = 0;
                }
                _temppic[j] = temppic2[j];
            }
            // begin to compare and combine two frame
            hex_to_array(_temppic);
            for(i = 0;i<8;i++){
                for(j = 0;j<8;j++){
                    post1[i][j] = return_position[i][j];
                }
            }
            hex_to_array(pic);
            for(i = 0;i<8;i++){
                for(j = 0;j<8;j++){
                    post2[i][j] = return_position[i][j];
                }
            }

            // begin to check boypeacemaker
            ch_same_position(post1,post2);
            for(i=0;i<8;i++){
                for(j=0;j<8;j++){
                    get_same_position[i][j] = ch_post[i][j];
                    if(get_same_position[i][j] == 1){
                        wow = 1;
                    }
                }
            }
            if(wow == 0){
                for(i=0;i<8;i++){_temppic[i] = temppic2[i]+pic[i];}
            }
            else{
                discard_same_position(post1,post2);
                array_to_hex(post1);
                for(i = 0;i<8;i++){
                    hex_post1[i] = return_hex[i];
                }
                array_to_hex(post2);
                for(i = 0;i<8;i++){
                    hex_post2[i] = return_hex[i];
                }
                array_to_hex(get_same_position);
                for(i = 0;i<8;i++){
                    hex_post_cut[i] = return_hex[i];
                }
                for(i = 0;i<8;i++){
                    _temppic[i] = hex_post1[i] + hex_post2[i] + hex_post_cut[i];
                }
            }
        }
        check_boat3 = 0;
    }
    if(dir == 's' && temppic2[7] == 0){
        for(j=0;j<8;j++){
            if(j == 0){
                forshift[0] = 0;
            }
            else{
                forshift[j] = temppic2[j-1];
            }
        }
        for(j=0;j<8;j++){
            temppic2[j] = forshift[j];
            _temppic[j] = temppic2[j];
        }
        // begin to compare and combine two frame
        hex_to_array(_temppic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post1[i][j] = return_position[i][j];
            }
        }
        hex_to_array(pic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post2[i][j] = return_position[i][j];
            }
        }

        // begin to check boypeacemaker
        ch_same_position(post1,post2);
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                get_same_position[i][j] = ch_post[i][j];
                if(get_same_position[i][j] == 1){
                    wow = 1;
                }
            }
        }
        if(wow == 0){
            for(i=0;i<8;i++){_temppic[i] = temppic2[i]+pic[i];}
        }
        else{
            discard_same_position(post1,post2);
            array_to_hex(post1);
            for(i = 0;i<8;i++){
                hex_post1[i] = return_hex[i];
            }
            array_to_hex(post2);
            for(i = 0;i<8;i++){
                hex_post2[i] = return_hex[i];
            }
            array_to_hex(get_same_position);
            for(i = 0;i<8;i++){
                hex_post_cut[i] = return_hex[i];
            }
            for(i = 0;i<8;i++){
                _temppic[i] = hex_post1[i] + hex_post2[i] + hex_post_cut[i];
            }
        }

    }
}
// ******************************************************************** ship 2 channal ******************************************************************

void place_ship2_4(int ship,char dir){

    int post1[8][8] = {0};
    int post2[8][8] = {0};
    int hex_post1[8] = {0};
    int hex_post2[8] = {0};
    int hex_post_cut[8] = {0};
    int get_same_position[8][8];
    int wow=0;

    if(dir == 'w'&& temppic3[ship][0] == 0 ){
        for(j=0;j<8;j++){
            if(j == 7){
                forshift[7] = 0;
            }
            else{
                forshift[j] = temppic3[ship][j+1];
            }
        }
        for(j=0;j<8;j++){
            temppic3[ship][j] = forshift[j];
            _temppic[j] = temppic3[ship][j];
        }
        // begin to compare and combine two frame
        hex_to_array(_temppic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post1[i][j] = return_position[i][j];
            }
        }
        hex_to_array(pic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post2[i][j] = return_position[i][j];
            }
        }

        // begin to check boypeacemaker
        ch_same_position(post1,post2);
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                get_same_position[i][j] = ch_post[i][j];
                if(get_same_position[i][j] == 1){
                    wow = 1;
                }
            }
        }
        if(wow == 0){
            for(i=0;i<8;i++){_temppic[i] = temppic3[ship][i]+pic[i];}
        }
        else{
            discard_same_position(post1,post2);
            array_to_hex(post1);
            for(i = 0;i<8;i++){
                hex_post1[i] = return_hex[i];
            }
            array_to_hex(post2);
            for(i = 0;i<8;i++){
                hex_post2[i] = return_hex[i];
            }
            array_to_hex(get_same_position);
            for(i = 0;i<8;i++){
                hex_post_cut[i] = return_hex[i];
            }
            for(i = 0;i<8;i++){
                _temppic[i] = hex_post1[i] + hex_post2[i] + hex_post_cut[i];
            }
        }

    }
    if(dir == 'd' && temppic3[ship][0] != 0x80 && temppic3[ship][1] != 0x80 && temppic3[ship][2] != 0x80 && temppic3[ship][3] != 0x80 && temppic3[ship][4] != 0x80 && temppic3[ship][5] != 0x80 && temppic3[ship][6] != 0x80 && temppic3[ship][7] != 0x80 ){
        for(j=0;j<8;j++){
            if(temppic3[j] != 0){
                temppic3[ship][j] = temppic3[ship][j]*2;
            }
            else{
                temppic3[ship][j] = 0;
            }
            _temppic[j] = temppic3[ship][j];
        }
        // begin to compare and combine two frame
        hex_to_array(_temppic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post1[i][j] = return_position[i][j];
            }
        }
        hex_to_array(pic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post2[i][j] = return_position[i][j];
            }
        }

        // begin to check boypeacemaker
        ch_same_position(post1,post2);
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                get_same_position[i][j] = ch_post[i][j];
                if(get_same_position[i][j] == 1){
                    wow = 1;
                }
            }
        }
        if(wow == 0){
            for(i=0;i<8;i++){_temppic[i] = temppic3[ship][i]+pic[i];}
        }
        else{
            discard_same_position(post1,post2);
            array_to_hex(post1);
            for(i = 0;i<8;i++){
                hex_post1[i] = return_hex[i];
            }
            array_to_hex(post2);
            for(i = 0;i<8;i++){
                hex_post2[i] = return_hex[i];
            }
            array_to_hex(get_same_position);
            for(i = 0;i<8;i++){
                hex_post_cut[i] = return_hex[i];
            }
            for(i = 0;i<8;i++){
                _temppic[i] = hex_post1[i] + hex_post2[i] + hex_post_cut[i];
            }
        }

    }
    if(dir == 'a' && temppic3[ship][0] != 0x01 && temppic3[ship][1] != 0x01 && temppic3[ship][2] != 0x01 && temppic3[ship][3] != 0x01 && temppic3[ship][4] != 0x01 && temppic3[ship][5] != 0x01 && temppic3[ship][6] != 0x01 && temppic3[ship][7] != 0x01){
        for(j=0;j<8;j++){
            if(temppic3[ship][j] != 0){
                temppic3[ship][j] = temppic3[ship][j]/2;
            }
            else{
                temppic3[ship][j] = 0;
            }
            _temppic[j] = temppic3[ship][j];
        }
        // begin to compare and combine two frame
        hex_to_array(_temppic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post1[i][j] = return_position[i][j];
            }
        }
        hex_to_array(pic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post2[i][j] = return_position[i][j];
            }
        }

        // begin to check boypeacemaker
        ch_same_position(post1,post2);
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                get_same_position[i][j] = ch_post[i][j];
                if(get_same_position[i][j] == 1){
                    wow = 1;
                }
            }
        }
        if(wow == 0){
            for(i=0;i<8;i++){_temppic[i] = temppic3[ship][i]+pic[i];}
        }
        else{
            discard_same_position(post1,post2);
            array_to_hex(post1);
            for(i = 0;i<8;i++){
                hex_post1[i] = return_hex[i];
            }
            array_to_hex(post2);
            for(i = 0;i<8;i++){
                hex_post2[i] = return_hex[i];
            }
            array_to_hex(get_same_position);
            for(i = 0;i<8;i++){
                hex_post_cut[i] = return_hex[i];
            }
            for(i = 0;i<8;i++){
                _temppic[i] = hex_post1[i] + hex_post2[i] + hex_post_cut[i];
            }
        }

    }
    if(dir == 's' && temppic3[ship][7] == 0){
        for(j=0;j<8;j++){
            if(j == 0){
                forshift[0] = 0;
            }
            else{
                forshift[j] = temppic3[ship][j-1];
            }
        }
        for(j=0;j<8;j++){
            temppic3[ship][j] = forshift[j];
            _temppic[j] = temppic3[ship][j];
        }
        // begin to compare and combine two frame
        hex_to_array(_temppic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post1[i][j] = return_position[i][j];
            }
        }
        hex_to_array(pic);
        for(i = 0;i<8;i++){
            for(j = 0;j<8;j++){
                post2[i][j] = return_position[i][j];
            }
        }

        // begin to check boypeacemaker
        ch_same_position(post1,post2);
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                get_same_position[i][j] = ch_post[i][j];
                if(get_same_position[i][j] == 1){
                    wow = 1;
                }
            }
        }
        if(wow == 0){
            for(i=0;i<8;i++){_temppic[i] = temppic3[ship][i]+pic[i];}
        }
        else{
            discard_same_position(post1,post2);
            array_to_hex(post1);
            for(i = 0;i<8;i++){
                hex_post1[i] = return_hex[i];
            }
            array_to_hex(post2);
            for(i = 0;i<8;i++){
                hex_post2[i] = return_hex[i];
            }
            array_to_hex(get_same_position);
            for(i = 0;i<8;i++){
                hex_post_cut[i] = return_hex[i];
            }
            for(i = 0;i<8;i++){
                _temppic[i] = hex_post1[i] + hex_post2[i] + hex_post_cut[i];
            }
        }

    }
}