/* *** INCLUDE **********************************************************************/
    #include "mbed.h"
    #include "rtos.h"
    #include "nRF24L01P.h"

/* *** DEFINE ***********************************************************************/
    #define sDestination_SIZE 20
    #define sMessage_SIZE     100
    
    #define MF_RESET PC_13
    #define TRANSFER_SIZE_NRF  4
    #define TRANSFER_SIZE_UART 100
    #define nCS  PA_15    
    #define SCK  PB_3
    #define MISO PB_4
    #define MOSI PB_5
    #define IRQ  PB_6
    #define CE   PB_7

/* *** THREADS **********************************************************************/
    void LED_thread(void const *args);
    void MAIL_thread(void const *args);

/* *** FUNCTIONS ********************************************************************/
    void initUART (void);
    void initWireLess(void);
    void UART_GetMessage(void);
    void WLESS_GetMessage(void);
    void flushCArray(char str[]);

/* *** GLOBAL DATA ******************************************************************/
// UART
    Serial raspPi(USBTX, USBRX);
    char getRaspPiData[TRANSFER_SIZE_UART], sendRaspPiData[TRANSFER_SIZE_UART];
    int  getRaspPiDataCnt, sendRaspPiDataCnt = 0;

// WIRELESS
    InterruptIn irqWLESS(IRQ);
    nRF24L01P NRF(MOSI, MISO, SCK, nCS, CE, IRQ); 
    char getWLESSData[TRANSFER_SIZE_NRF], sendWLESSData[TRANSFER_SIZE_NRF];
    int  getWLESSDataCnt, sendWLESSDataCnt = 0;
    unsigned long long myAdress = 0x010203;
    unsigned long long otherAdress = 0x030201;

// MAIL
    typedef struct mail_t {
        char sDestination[sDestination_SIZE];   // Name of the Thread
        char sMessage[sMessage_SIZE];       // Type here you message
    }mail_t;
    
    Mail<mail_t, 10> mailBox;
    mail_t *mail;

DigitalOut led2(LED2);
//Use for debug!!
DigitalOut check1(PB_15);
DigitalOut check2(PB_14);
DigitalOut check3(PB_13);
// End debug

/* *** MAIN *************************************************************************/ 
int main() {

    Thread threadLED(LED_thread);
    Thread threadMAIL(MAIL_thread);
    initUART();
    initWireLess();
    irqWLESS.fall(&WLESS_GetMessage);    
        
    while(1) { 
        ;
    }
}

/* *** LED THREAD *******************************************************************/
void LED_thread(void const *args) {
    while (true) {        
        led2 = !led2;
        Thread::wait(500);       
    }    
}

/* *** MAIL THREAD ******************************************************************/
void MAIL_thread(void const *args) {
    while(true) {
        osEvent evt = mailBox.get();        
/*
        if (evt.status == osEventMail) {
            if (strcmp(mail->sDestination, "WLESS") == 0) {
                // functie aanroepen voor de NRF       
            }
            else if (strcmp(mail->sDestination, "UART") == 0) {
                // functie aanroepen voor de UART
            }            
            else if (strcmp(mail->sDestination, "LED") == 0) {
                // functie aanroepen voor de LED
            }
            mailBox.free(mail);                     
        }
*/                
        if (evt.status == osEventMail) {
            if (strcmp(mail->sDestination, "WLESS") == 0) {                 
                
                raspPi.printf("Data from mail: %s ", mail->sMessage);

                sendWLESSDataCnt = 0;
// Deze functie werkt nog helemaal omdat er per 4 bytes verstuurd moeten worden...
// Wanneer dit aangepast wordt doet hij het voor 100%!                
                for (int sndData = 0; mail->sMessage[sndData] != '!'; sndData++) {
                    
                    
                    sendWLESSData[sendWLESSDataCnt++] = mail->sMessage[sndData];
                                       
                    if (sendWLESSDataCnt == TRANSFER_SIZE_NRF) {
                        
                        NRF.write( NRF24L01P_PIPE_P0, sendWLESSData, TRANSFER_SIZE_NRF);
                        sendWLESSDataCnt = 0;
                    }
                    else if (mail->sMessage[sndData] == '!') {
                        
                        for (int sndRestData = sendWLESSDataCnt; sndRestData <= TRANSFER_SIZE_NRF; sndRestData++) {
                            sendWLESSData[sndRestData] = 0;
                        }
                        NRF.write( NRF24L01P_PIPE_P0, sendWLESSData, TRANSFER_SIZE_NRF );                        
                    }                                  
                } 
                             
                flushCArray(sendWLESSData);
                mailBox.free(mail);                
            }              
        }
        Thread::wait(100);
    } 
}

/* *** INIT UART ********************************************************************/
void initUART () {
    raspPi.baud(9600);        
    raspPi.attach(&UART_GetMessage);
    flushCArray(getRaspPiData);
    flushCArray(sendRaspPiData);
    raspPi.printf("Hi, from NUCLEO! \r\n");
}


/* *** INIT WIRELESS ****************************************************************/
void initWireLess() {
    flushCArray(getWLESSData);
    flushCArray(sendWLESSData);
        
    NRF.powerUp();
    NRF.setTransferSize( TRANSFER_SIZE_NRF );
    NRF.setTxAddress(otherAdress, 3);
    NRF.setRxAddress(otherAdress, 3, NRF24L01P_PIPE_P0);
    NRF.enableAutoAcknowledge(NRF24L01P_PIPE_P0);
    NRF.enableAutoRetransmit(1000, 10);
    NRF.setAirDataRate(NRF24L01P_DATARATE_250_KBPS);
    NRF.setRfOutputPower(NRF24L01P_TX_PWR_ZERO_DB);
    NRF.setRxAddress(myAdress, 3, NRF24L01P_PIPE_P1);
    NRF.setRfFrequency(2500);
    
    NRF.setReceiveMode();
    NRF.enable();
    
    // USE FOR DEBUG
    raspPi.printf( "NRF+ Frequency    : %d MHz\r\n",  NRF.getRfFrequency() );
    raspPi.printf( "NRF+ Output power : %d dBm\r\n",  NRF.getRfOutputPower() );
    raspPi.printf( "NRF+ Data Rate    : %d kbps\r\n", NRF.getAirDataRate() );
    raspPi.printf( "NRF+ TX Address   : 0x%010llX\r\n", NRF.getTxAddress() );
    raspPi.printf( "NRF+ RX0 Address   : 0x%010llX\r\n", NRF.getRxAddress(0) );
    raspPi.printf( "NRF+ RX1 Address   : 0x%010llX\r\n", NRF.getRxAddress(1) );
    raspPi.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE_NRF );
             
}

/* *** UART GET MESSAGE *************************************************************/
void UART_GetMessage () {
 
    if (getRaspPiDataCnt <= TRANSFER_SIZE_UART){
        getRaspPiData[getRaspPiDataCnt] = raspPi.getc();    
        raspPi.putc(getRaspPiData[getRaspPiDataCnt]);
        getRaspPiDataCnt++;
    }
    
    if(getRaspPiData[getRaspPiDataCnt-1] == '!'){               
        mail = mailBox.alloc();
        //strncpy (mail->sDestination, "WLESS", strlen("WLESS"));
        //strncpy (mail->sMessage, getRaspPiData, getRaspPiDataCnt-1);
        strcpy (mail->sDestination, "WLESS");
        strcpy (mail->sMessage, getRaspPiData);
        mailBox.put(mail);
        getRaspPiDataCnt = 0;                
        flushCArray(getRaspPiData);
    }                    
}

/* *** WIRELESS GET MESSAGE *********************************************************/
void WLESS_GetMessage () {
// Deze functie nog niet getest!    
    getWLESSDataCnt = NRF.read( NRF24L01P_PIPE_P0, getWLESSData, sizeof( getWLESSData ) );
    
    for ( int i = 0; getWLESSDataCnt > 0; getWLESSDataCnt--, i++ ) {
        raspPi.putc( getWLESSData[i] );
    }    
}

/* *** FLUSH CHAR ARRAY *************************************************************/
void flushCArray(char str[]) {
    memset(str, '\n', strlen(str));
}
