#include "mbed.h"
#include "MMA7660.h"
#include "stdio.h" //needed?
/*THIS FILE IS MADE TO RUN ON THE MBED. IT WILL TAKE ACCELEROMETER VALUES AND WRITE THEM
TO A TEXT FILE AND THEN A CONNECTED COMPUTER*/

DigitalOut myled(LED1);
MMA7660 MMA(p28, p27); // Accelerometer connections
float ax, ay, az; //allocations for the x, y, z values
Serial pc(USBTX,USBRX); // serial port
LocalFileSystem local("local"); // Create the local filesystem called "local"
int main()
{
    float data[100]; // three data arrays, with 100 entries
    float data1[100];
    float data2[100];


    for (int i=0; i<100; i++) 
    {
        ax=90*MMA.x(); //ax is the x value from the accelerometer. the *90 part is to get an angle
        data[i] = ax ; //place the value of the accelerometer into the 1st array
        ay=90*MMA.y();
        data1[i] = ay ;
        az=90*MMA.z();
        data2[i] = az;
        
        wait (0.1);// so all the results aren't taken as quickly as the mbed can process. total time = wait time * number of items in array
    }
    
    myled = 1;//flash an led to display the program has stopped taking readings
    wait(0.2);
    myled = 0;
    wait(0.2);

    FILE *fpacc = fopen("/local/accvalues.txt", "w"); // Open "accvalues.txt"
    for (int i=0; i<100; i++) 
    {
        fprintf(fpacc,"%f %f %f \n ",data[i], data1[i], data2[i]); //print the data values to the file
    }
    fclose(fpacc); //save and close the file

    pc.printf("these are the accelerometer values: \n");//we will not need this on the day of testing, we only need to save the data on the mbed
    for (int i=0; i<100; i++) 
    {
        pc.printf("%f %f %f\n",data[i], data1[i], data2[i]); //print the values to the pc via putty
    }
}



