#include "CMPS03.h"
#include "mbed.h"

CMPS03 compass(p9, p10, CMPS03_DEFAULT_I2C_ADDRESS);
Serial pc(USBTX, USBRX);
LocalFileSystem local("local"); // Create the local filesystem called "local"
float data[100];
DigitalOut myled(LED3);

 
int main() {
 
        for (int i=0; i<100; i++) 
    {
        data[i] = (compass.readBearing() / 10.0);
        wait (0.1);// so all the results aren't taken as quickly as the mbed can process. total time = wait time * number of items in array
    }
    
    myled = 1;//flash an led to display the program has stopped taking readings
    wait(0.2);
    myled = 0;
    wait(0.2);

    FILE *fpcmp = fopen("/local/cmpvalues.txt", "w"); // Open "cmpvalues.txt"
    for (int i=0; i<100; i++) 
    {
        fprintf(fpcmp,"%f \n ",data[i]); //print the data values to the file
    }
    fclose(fpcmp); //save and close the file
    
    }