
/* The setup:
 
   -   +C---\    r1 = (30 -- 50)
   |   |     ----\
   |   |          ----\
   |   |               ---\
 d=30  +D-  -  -  -  -  -  +B
   |   |               ---/
   |   |          ----/
   |   |     ----/
   -   +A---/    r2 = (30 -- 50)
   |   |
   |   |
   |   |
 h=20  |
   |   |
   |   |
   |   |
   -   O
   
   xB = DB
   yB = OD = h + 0.5*d
 
*/



/*
    Constants
*/

const float L_max = 50.0;   // Max arm length
const float L_min = 30.0;   // Min arm length

const float d = 30.0;       // Distance between arm centres of rotation 
const float h = 20.0;       // Height of lower arm centre of rotation

const float reach = 2*sqrt(pow(L_max,2)-pow(L_min,2))-d;    // Total length of wall that can be covered

const float y_max = (2*h + d)/2 + reach/2;
const float y_min = (2*h + d)/2 - reach/2;

const float x_min = L_min;
const float x_max = 0;  

/*
    Methods
*/

void getArmLengthsForRollerPosition(float x, float y, float &upper, float &lower);
void getRollerPositionForArmLengths(float upper, float lower, float &x, float &y);
