#include "math.h" 
#include "geometry.h"  

// Sets the required arm lengths in the 'upper' and 'lower' parameters
void getArmLengthsForRollerPosition(float x, float y, float &upper, float &lower) {
    lower = sqrt(pow(y-h,2)+pow(x,2));
    upper = sqrt(pow(lower,2)+pow(d,2)-2*d*sqrt(pow(lower,2)-pow(x,2)));
}

// Sets the roller position corresponding to the current arm lengths in the x and y parameters
void getRollerPositionForArmLengths(float upper, float lower, float &x, float &y) {
    y = (pow(lower,2)-pow(upper,2)+2*h*d+pow(d,2))/(2*d);
    x = sqrt(-((pow(lower, 4) + pow(upper, 4))/(4*pow(d, 2)))+((pow(lower, 2)*pow(upper, 2))/(2*pow(d,2)))-(pow(upper,2)/2)+(pow(d,2)/4)+pow(lower, 2));
}
