#include "PID_controller.h"

PIDController::PIDController(float _Kp, float _Ki, float _Kd)  {
    Kp = _Kp;
    Ki = _Ki;
    Kd = _Kd;
    previousError = 0;
    errorIntegral = 0;   
}

float PIDController::control(float error, float t) {
    // Integral
    errorIntegral += error * t;
    // Derivative
    float d = (previousError - error)/t;
    previousError = error;
    // PID
    return error * Kp + errorIntegral * Ki + d * Kd;
}