#include "arm.h"
#include "PID_controller.h"
#include "geometry.h"

class Robot {
    private:
        // Arms
        Arm upperArm;
        Arm lowerArm;

        // Safety first! (If this flag is set, the robot will not move)
        volatile bool killed;
        
    public:
        // Constructor
        Robot();
        // Update arm instance variables
        void update();
        // Get upper arm length
        float getUpperArmLength();
        // Get lower arm length
        float getLowerArmLength();
        // Get upper arm velocity estimation by the encoder (rad/s)
        float getUpperArmEncoderVelocity();
        // Get lower arm velocity estimation by the encoder (rad/s)
        float getLowerArmEncoderVelocity();
        // Set upper arm reference velocity
        void setUpperArmVelocity(float referenceVelocity);
        // Set lower arm reference velocity
        void setLowerArmVelocity(float referenceVelocity);
        // Safety shutdown
        void kill();
        bool isKilled();

};



