#include "controller.h"

//Serial pc(USBTX, USBRX);

RobotController controller;

AnalogIn upperPotMeter(A0);
AnalogIn lowerPotMeter(A1);

InterruptIn button(D2);
//InterruptIn killButton(D3);

int stateCounter = 0;

void readArmLengths(float &upper, float &lower) {
    upper = L_min + (L_max - L_min) * upperPotMeter;
    lower = L_min + (L_max - L_min) * lowerPotMeter;
}

void onButtonPress() {
//    float upper;
//    float lower;
//    readArmLengths(upper, lower);
    
//    pc.printf("Reference: Lower: %f, Upper: %f\n\r", lower, upper);
//    pc.printf("Encoder:   Lower: %f, Upper: %f\n\r", controller.getLowerArmLength(), controller.getUpperArmLength());
//    pc.printf("Robot killed: %s\n\r", controller.isKilled()? "Yes":"No");
//    controller.setArmLengths(upper, lower);
    
    if (stateCounter == 0) {
        controller.goToTop();
        stateCounter++;
    }
    else if (stateCounter == 1) {
        controller.paintDown();
        stateCounter++;
    }
    else if (stateCounter == 2) {
        controller.paintUp();
        stateCounter = 1;
    }
    
}


//int main() {
//    pc.baud(115200);
//    button.fall(&onButtonPress);
//    killButton.fall(controller.getRobot(), &Robot::kill);
//    pc.printf("Initialized\n\r");
//    while (true);
//    
//}


