/*   Calculating Roll, Pitch and Yaw angles from IMU
*
*    @author: Baser Kandehir 
*    @date: August 5, 2015
*    @license: MIT license
*     
*   Copyright (c) 2015, Baser Kandehir, baser.kandehir@ieee.metu.edu.tr
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to deal
*   in the Software without restriction, including without limitation the rights
*   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*   copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*   THE SOFTWARE.
*   
*    @description of the program: 
*
*   Program can calculate roll, pitch and yaw angles from the raw data that comes 
*   from IMU. Yaw angle is compensated for tilt. All the angles are sent to the matlab
*   for further processing.
*     
*/

#include "mbed.h"
#include "HMC5883L.h"
#include "MPU6050.h"
#include "ledControl.h"

Serial pc(USBTX,USBRX);    
MPU6050 mpu6050;           
HMC5883L hmc5883l;    
Ticker toggler1;
Ticker filter;   
Ticker compass;        
Timer tt;
void toggle_led1();
void toggle_led2();
void compFilter();
void tiltCompensatedAngle();

float pitchAngle = 0;
float rollAngle = 0;
float yawAngle = 0;
float ve[3] ={0,0,0};
float n_a[3]={0,0,0};
static float s_b[3]={0,0,0};
void AcceltoVelo(float aax,float aay,float aaz,float delttat)
{ int cc=0;
    static float old_a[3]={0,0,0};
    float deax,deay,deaz;
    
    deax=aax-old_a[0];
    deay=aay-old_a[1];
    deaz=aaz-old_a[2];
    ve[0]=deax*delttat;
    ve[1]=deay*delttat;
    ve[2]=deaz*delttat;
old_a[0]=aax;
    old_a[1]=aay;
    old_a[2]=aaz;
    //pc.printf("%f %f %f\n",deax,deay,deaz);
}
void VelotoDis(float vvx,float vvy,float vvz,float delttat){
    s_b[0]+=vvx*delttat;
    s_b[1]+=vvy*delttat;
    s_b[2]+=vvz*delttat;
    }
void cali(){
    int c=0;
    float c_ax=0,c_ay=0,c_az=0;
    while (c<1000){
        c_ax+=ax;
        c_ay+=ay;
        c_az+=az;
        c+=1;
        wait(0.0001);
        }
    pc.printf("%f %f %f\n",c_ax/1000,c_ay/1000,c_az/1000);
    }
int main() 

{static float vvv[3]={0,0,0}; 
tt.start();
    pc.baud(115200);                                 // baud rate: 9600
    mpu6050.whoAmI();                              // Communication test: WHO_AM_I register reading 
    mpu6050.calibrate(accelBias,gyroBias);         // Calibrate MPU6050 and load biases into bias registers
    mpu6050.init();                                // Initialize the sensor
    hmc5883l.init();
    filter.attach(&compFilter,    0.005);              // Call the complementaryFilter func.  every 5 ms (200 Hz sampling period)
    compass.attach(&tiltCompensatedAngle, 0.015);      // Call the tiltCompensatedAngle func. every 15 ms (75 Hz sampling period)
    //cali();
    float cc0=0;
    int dd=0;
    while(1) 
    {  
    AcceltoVelo(ax*10,ay*10,az*10,3);
    vvv[0]=ve[0]*0.02+vvv[0]*0.98;
    vvv[1]=ve[1]*0.02+vvv[1]*0.98;
    vvv[2]=ve[2]*0.02+vvv[2]*0.98;
    //wait_ms(4);
        //pc.printf("%f\n",vvv[2]);
        //pc.printf("%f %f %f\r\n",vvv[0],vvv[1],vvv[2]);
      /*f(tt.read_us()-cc0>3000 && dd==0){
        dd=1;
        VelotoDis(vvv[0],vvv[1],vvv[2],6);
        pc.printf("%f %f %f\r\n",s_b[0],s_b[1],s_b[2]);cc0=tt.read_us();
        }else{
            VelotoDis(vvv[0],vvv[1],vvv[2],6);
        pc.printf("%f %f %f\r\n",s_b[0],s_b[1],s_b[2]);cc0=tt.read_us();
        }*/
        pc.printf("%f %f %f\r\n",ax,ay,az);
        //pc.printf("%.1f,%.1f,%.1f\r\n",rollAngle,pitchAngle,yawAngle);  // send data to matlab
        wait_us(3);
    }
}

void toggle_led1() {ledToggle(1);}
void toggle_led2() {ledToggle(2);}

/* This function is created to avoid address error that caused from Ticker.attach func */ 
void compFilter() {mpu6050.complementaryFilter(&pitchAngle, &rollAngle);}

/* Tilt compensated compass data */
// Works well for tilt in +/- 50 deg range
void tiltCompensatedAngle() 
{   
    float mag_Data[3], Xh, Yh;
    hmc5883l.readMagData(mag_Data);
    
    Xh = mag_Data[0] * cos(rollAngle*PI/180) - mag_Data[2] * sin(rollAngle*PI/180) ;
    
    Yh = mag_Data[0] * sin(pitchAngle*PI/180) * sin(rollAngle*PI/180) + 
    mag_Data[1] * cos(pitchAngle*PI/180) -
    mag_Data[2] * sin(pitchAngle*PI/180) * cos(rollAngle*PI/180) ;
    
    /* Calculate the compensated heading angle */
    double heading = atan2(Yh, Xh);
    
    // After calculating heading declination angle should be added to heading which is the error of the magnetic field in specific location.
    // declinationAngle can be found here http://www.magnetic-declination.com/
    // For Ankara (my location) declinationAngle is ~5.5 degrees (0.096 radians)
    float declinationAngle = 0.096;
    heading += declinationAngle;
    
    // Correct for when signs are reversed.
    if(heading < 0)
        heading += 2*PI;
    
    // Check for wrap due to addition of declination.
    if(heading > 2*PI)
        heading -= 2*PI;
    
    /* Convert radian to degrees */
    heading = heading * 180 / PI;  
    
    yawAngle = heading; 
}
