#include "mbed.h"
#include "rtos.h"
#include <string>
#include <stdio.h>

/////DEFINISJONER/////
#define Inn 4
Serial pc(USBTX, USBRX);
LocalFileSystem local("local");
FILE *fp = fopen("/local/log.txt", "w" ) ;

/////INNGANGER/////
DigitalIn Servicebryter(p20);
AnalogIn _Sone1(p15);
AnalogIn _Sone2(p16);
AnalogIn _Sone3(p17);
AnalogIn _Sone4(p19);

/////UTGANGER/////
DigitalOut Driftslys(LED1);
BusOut AlarmUtganger1(p21, p22, p23, p24); //1 - Dør 1 Sone 1, 2 - Dør 1 Sone 2, 4 - Dør 1 Sone 3, 8 - Dør 1 Sone 4
BusOut AlarmUtganger2(p25, p26, p27, p28); //1 - Dør 2 Sone 1, 2 - Dør 2 Sone 2, 4 - Dør 2 Sone 3, 8 - Dør 2 Sone 4

/////VARIABLER/////
float Soner[Inn];
int tilstand = 0;
volatile bool running = true;
volatile bool admin = false;
string password = ("admin");
Timer t;

/////FUNKSJON DEKLARASJONER/////
void Alarmf();
Thread Alarm;
int TilstandSjekk(int, int);
void admin_access_granted();
void sone_monitor();
void password_check();
void read_keyinput();
void request_status();
void request_status_sone_dor(int sone, int dor);
extern "C" void mbed_reset();
int log_to_file(int, int);

/////MAIN/////
int main()
{
    t.start();
    while(1) {
        if(admin == false) {
            password_check();
        }
        if(Servicebryter == 1) {
            AlarmUtganger1 = 0;
            AlarmUtganger2 = 0;
            running = false;
            pc.printf("NB! Alle alarmer er i innelast modus i 15 sek!! \n");
            wait(10);
            pc.printf("NB! Alarmer gar pa om 5 sek! \n");
            wait(5);
        }
        while((admin) && (Servicebryter == 0)) {
            Alarm.start(Alarmf);
            sone_monitor();
            read_keyinput();
        }
    }
}

/////FUNKSJONER/////
void Alarmf(void)
{
    while(1) {
        if(running == true) {
            Driftslys = !Driftslys;
            Thread::wait(50);
        } else {
            Driftslys = 1;
        }
    }
}

int TilstandSjekk(int i, int tilstand)
{
    log_to_file(i, tilstand);
    if(tilstand == 0) {
        running = false;
        double n = 2;
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if ( Y == AlarmUtganger1) AlarmUtganger1 = AlarmUtganger1 - Y;
        if ( Y == AlarmUtganger2) AlarmUtganger2 = AlarmUtganger2 - Y;
    }
    if(tilstand == 1) { //Hvis dør 1 er åpen...
        running = true;
        double n = 2;
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y == AlarmUtganger2 ) AlarmUtganger2 = AlarmUtganger2 - Y;
        if( Y!=AlarmUtganger1) AlarmUtganger1 = Y + AlarmUtganger1; //Sjekk om denne verdien har blitt sjekket før, hvis ikke starter alarm på neste dør.
    }
    if(tilstand == 2) { //Hvis dør 2 er åpen...
        running = true;
        double n = 2;
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y == AlarmUtganger1 ) AlarmUtganger1 = AlarmUtganger1 - Y;
        if( Y!=AlarmUtganger2) AlarmUtganger2 = Y + AlarmUtganger2;  //Sjekk om denne verdien har blitt sjekket før, hvis ikke starter alarm på neste dør.
    }
    if(tilstand == 3) { //Hvis begge dører er åpne
        running = true;
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y!=AlarmUtganger1 ) AlarmUtganger1 = Y + AlarmUtganger1;
        if( Y!=AlarmUtganger2 ) AlarmUtganger2 = Y + AlarmUtganger2;
    }
    return 0;
}

int log_to_file(int i, int tilstand)
{
    int p;
    FILE *fp = fopen("/local/log.txt", "w" ) ;
    if(fp != NULL) {
        if ((tilstand == 1) && (p != 1)) {
            fprintf(fp,"Sone %d, dor 1 er aapen \n",i);
            fprintf(fp,"Tid:%f siden start \n",t.read());
            p = 1;
        }

        if ((tilstand == 2) && (p != 2)) {
            fprintf(fp,"Sone %d, dor 2 er lukket \n",i);
            fprintf(fp,"Tid:%f siden start \n",t.read());
            p = 2;
        }
        if ((tilstand == 3) && (p != 3)) {
            fprintf(fp,"Sone %d dor 1 og 2 er lukket \n",i);
            fprintf(fp,"Tid:%f siden start \n",t.read());
            p = 3;
        }
    }
    return 0;
}

void sone_monitor()
{
    Soner[0] = _Sone1;
    //Soner[1] = _Sone2;
    //Soner[2] = _Sone3;
    //Soner[3] = _Sone4;
    for(int i=0; i < Inn; i++) {
        if((Soner[i] > 0.75 )&&( Soner[i] < 0.83)) { //Tilstand1, Dør 1 åpen
            //pc.printf("Vi er i Tilstand1\n");
            tilstand = 1;
            TilstandSjekk(i, tilstand);
        }
        if((Soner[i] > 0.55 )&&( Soner[i] < 0.59)) { //Normaldrift
            tilstand = 0;
            TilstandSjekk(i, tilstand);
        }
        if((Soner[i] > 0.65 )&&( Soner[i] < 0.69)) { //Tilstand2, Dør 2 åpen
            tilstand = 2;
            TilstandSjekk(i, tilstand);
        }
        if(Soner[i] >= 1) { //Tilstand 3, Begge dører er åpen
            tilstand = 3;
            TilstandSjekk(i, tilstand);
        }
    }
}
void admin_access_granted()
{
    admin = true;
    pc.printf("Admin access granted\n");//info
    pc.printf("Folgende kommandoer kan brukes: \n");// liste over funksjoner tilgjenglig.
    pc.printf("Status sone og dor(sone forst, dor etter) Kommando: 1,2 \n");// funksjon 1 - request spesific status
    pc.printf("Status alle soner og dorer. Kommando: Status \n");// funksjon 1 - request status all
    pc.printf("Reset hele systemet. Kommando: 'Reset' \n");// funksjon 4 - request log all
}

void password_check()
{
    if(pc.readable() == 1) {
        pc.printf("Write password: ");
        string b;
        char s;
        for(int i = 0; i < 5; i++) {
            s = pc.getc();
            pc.printf("%c", s);
            b += s;
            if(b == password) {
                admin_access_granted();
            }
        }
    }
}

void read_keyinput()
{
    if(pc.readable() == 1) {
        pc.printf("\nDu skriver: ");
        string read;
        char c;
        for(int i = 0; i < 6; i++) {
            c = pc.getc();
            pc.printf("%c ", c);
            read += c;
            if( read == ("1, 1")) request_status_sone_dor(1, 1);
            if( read == ("1, 2")) request_status_sone_dor(1, 2);
            if( read == ("2, 1")) request_status_sone_dor(2, 1);
            if( read == ("2, 2")) request_status_sone_dor(2, 2);
            if( read == ("3, 1")) request_status_sone_dor(3, 1);
            if( read == ("3, 2")) request_status_sone_dor(3, 2);
            if( read == ("4, 1")) request_status_sone_dor(4, 1);
            if( read == ("4, 2")) request_status_sone_dor(4, 2);
            if( read == ("Status")) request_status();
            if( read == ("Stop")) while(1){ fclose(fp); }
            if( read == ("Reset")) {
                fclose(fp);
                mbed_reset();
            }
        }
    }
}


void request_status_sone_dor(int sone, int dor)
{
    int n = 2;
    for(int i = 0; i <= 16;) {
        if(i == 0) i = 1;
        else i = i * n;
        if(sone == i) {
            if(dor == 1) {
                if(AlarmUtganger1 == sone) pc.printf("Dor: %d i sone: %d er apnet \n", dor, sone);
                else pc.printf("Dor: %d i sone: %d er lukket \n", dor, sone);
            }
            if(dor == 2) {
                if(AlarmUtganger2 == sone) pc.printf("Dor: %d i sone: %d er apnet \n", dor, sone);
                else pc.printf("Dor: %d i sone: %d er lukket \n", dor, sone);
            }
        }
    }
}

void request_status()
{
    int sone = 0;
    int n = 2;
    for(int i = 0; i <= 8;) {
        sone = sone + sone;
        if(i == 0) i = 1;
        else i = i*n;
        if(AlarmUtganger1 == i) pc.printf("Dor: 1 i Sone: %d er apent \n", sone);
        else pc.printf("Dor: 1 i Sone: %d er lukket \n", i);
        if(AlarmUtganger2 == i) pc.printf("Dor: 2 i Sone: %d er apent \n", sone);
        else pc.printf("Dor: 2 i Sone: %d er lukket \n", i);
    }
}