#include "mbed.h"
#include "rtos.h"
#include <RtosTimer.h>
#include <math.h>
#include "mbed_error.h"
#include<string> 

/////DEFINISJONER/////
#define Inn 4
Serial pc(USBTX, USBRX);
//#define Feil 0<1

/////INNGANGER/////
DigitalIn Servicebryter(p20);
AnalogIn _Sone1(p15);
AnalogIn _Sone2(p16);
AnalogIn _Sone3(p17);
AnalogIn _Sone4(p19);

/////UTGANGER/////
DigitalOut Driftslys(LED1);
BusOut AlarmUtganger1(p21, p22, p23, p24); //1 - Dør 1 Sone 1, 2 - Dør 1 Sone 2, 4 - Dør 1 Sone 3, 8 - Dør 1 Sone 4
BusOut AlarmUtganger2(p25, p26, p27, p28); //1 - Dør 2 Sone 1, 2 - Dør 2 Sone 2, 4 - Dør 2 Sone 3, 8 - Dør 2 Sone 4
//DigitalOut myled2(LED2);

/////VARIABLER/////
float Soner[Inn];
int tilstand = 0;
int TilstandSjekk(int, int);
volatile bool running = true;
string password = ("admin");
string keyinput;
//volatile int Klokke = 0;
//nt Tid = 0;

/////FUNKSJON DEKLARASJONER/////
void Alarmf();
Thread monitoring;
int Tilstandssjekk();
int admin_access_granted();
int sone_monitor();
int read_keyinput();
//void Alarm();
//Ticker AlarmBlink; // 10Hz blinking for alarmfunksjon på lys og telling


/////MAIN/////
int main()
{
    pc.printf("Write admin access password:\n");
    pc.scanf("%s",keyinput);
    if(keyinput == password){ 
    monitoring(sone_monitor);
    admin_access_granted();
        while(1) {
            RtosTimer Alarm(Alarmf);
            read_keyinput();
           
        }//while-end
    }//if-end
}//main-end




/////FUNKSJONER/////
void Alarmf(void)
{
    Driftslys = !Driftslys;
}

int TilstandSjekk(int i, int tilstand)
{
    if(tilstand == 0) {
        //pc.printf("Vi er i funksjonen normaldrift i sone: %d \n", i);
        //AlarmBlink.detach();
        Alarm.stop();
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if ( Y == AlarmUtganger1) AlarmUtganger1 = AlarmUtganger1 - Y;
        if ( Y == AlarmUtganger2) AlarmUtganger2 = AlarmUtganger2 - Y;
        int Utganger1 = AlarmUtganger1;
        int Utganger2 = AlarmUtganger2;
        //pc.printf("Utgangsbuss1 har naa verdien: %d \n Utgangsbuss2 har naa verdien: %d", Utganger1, Utganger2);
    }
    if(tilstand == 1) { //Hvis dør 1 er åpen...
        //pc.printf("Vi er i funksjonen tilstandssjekk dor 1, med verdi: %d\n", i);
        //Alarm();
        Alarm.start(50);
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y == AlarmUtganger2 ) AlarmUtganger2 = AlarmUtganger2 - Y;
        if( Y!=AlarmUtganger1) AlarmUtganger1 = Y + AlarmUtganger1; //Sjekk om denne verdien har blitt sjekket før, hvis ikke starter alarm på neste dør.
        int Utganger1 = AlarmUtganger1;
        //pc.printf("Vi har verdien paa utgangsbuss: %d\n", Utganger1);
    }
    if(tilstand == 2) { //Hvis dør 2 er åpen...
        //pc.printf("Vi er i funksjonen tilstandssjekk dor 2, med verdi: %d\n", i);
        //Alarm();
        Alarm.start(50);
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y == AlarmUtganger1 ) AlarmUtganger1 = AlarmUtganger1 - Y;
        if( Y!=AlarmUtganger2) AlarmUtganger2 = Y + AlarmUtganger2;  //Sjekk om denne verdien har blitt sjekket før, hvis ikke starter alarm på neste dør.
        int Utganger2 = AlarmUtganger2;
        //pc.printf("Vi har verdien paa utgangsbuss: %d\n", Utganger2);
    }
    if(tilstand == 3) { //Hvis begge dører er åpne
        //pc.printf("Vi er i funksjonen tilstandssjekk alle dorer, med verdi: %d \n", i);;
        // Alarm();
        Alarm.start(50);
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y!=AlarmUtganger1 ) AlarmUtganger1 = Y + AlarmUtganger1;
        if( Y!=AlarmUtganger2 ) AlarmUtganger2 = Y + AlarmUtganger2;
        int Utganger2 = AlarmUtganger2;
        int Utganger1 = AlarmUtganger2;
        //pc.printf("Utgangsbuss1 har verdien: %d \n Utgangsbuss2 har verdien: %d \n", Utganger1, Utganger2);
    }
    return 0;
}
sone_monitor()
{
    Soner[0] = _Sone1;
    //Soner[1] = _Sone2;
    //Soner[2] = _Sone3;
    //Soner[3] = _Sone4;
    for(int i=0; i < Inn; i++) {
        //pc.printf("%f\n", Soner[i]);
        if((Soner[i] > 0.75 )&&( Soner[i] < 0.83)) { //Tilstand1, Dør 1 åpen
            //pc.printf("Vi er i Tilstand1\n");
            tilstand = 1;
            TilstandSjekk(i, tilstand);
        }
        if((Soner[i] > 0.55 )&&( Soner[i] < 0.59)) { //Normaldrift
            //pc.printf("Vi er i Normaldrift\n")
            tilstand = 0;
            TilstandSjekk(i, tilstand);
        }
        if((Soner[i] > 0.65 )&&( Soner[i] < 0.69)) { //Tilstand 2, Dør 2 åpen
            //pc.printf("Vi er i tilstand2\n");
            tilstand = 2;
            TilstandSjekk(i, tilstand);
        }
        if(Soner[i] >= 1) { //Begge dører er åpne
            //pc.printf("Vi er i tilstand 3, begge doorer er aapne");
            tilstand = 3;
            TilstandSjekk(i, tilstand);
        }
        //wait(1.5);
    }
    //pc.printf("%f\n", Sone1[]);
    //Tilstandssjekk(Sone1[]);
    //float volt = Sone1[];
    //pc.printf("%f\n", volt);
    //while(sysclock == 1);
    //while(sysclock == 0);
    //Tid++;
}
admin_access_granted()
{
            pc.printf("Admin access granted\n");//info
            pc.printf("Following commands are available\n");// liste over funksjoner tilgjenglig.
            pc.printf("#req_sta_sone(1-4)_door(1-2)\n");// funksjon 1 - request spesific status
            pc.printf("#req_sta_all\n");// funksjon 1 - request status all
            pc.printf("#reset_sone(1-4)_door(1-2)\n");// funksjon 3 - request spesific log     
            pc.printf("#reset_all\n");// funksjon 4 - request log all
}
read_keyinput()
{
    serial.readabl
    pc.scanf("%s", keyinput);

/*void Alarm()
{
    Driftslys = !Driftslys;
    wait(0.05);
    }*/