#include "mbed.h"
#include "rtos.h"
#include <RtosTimer.h>
#include <math.h>
#include "mbed_error.h"
#include <string>
#include <iostream>

/////DEFINISJONER/////
#define Inn 4
Serial pc(USBTX, USBRX);
//#define Feil 0<1

/////INNGANGER/////
DigitalIn Servicebryter(p20);
AnalogIn _Sone1(p15);
AnalogIn _Sone2(p16);
AnalogIn _Sone3(p17);
AnalogIn _Sone4(p19);

/////UTGANGER/////
DigitalOut Driftslys(LED1);
BusOut AlarmUtganger1(p21, p22, p23, p24); //1 - Dør 1 Sone 1, 2 - Dør 1 Sone 2, 4 - Dør 1 Sone 3, 8 - Dør 1 Sone 4
BusOut AlarmUtganger2(p25, p26, p27, p28); //1 - Dør 2 Sone 1, 2 - Dør 2 Sone 2, 4 - Dør 2 Sone 3, 8 - Dør 2 Sone 4
//DigitalOut myled2(LED2);

/////VARIABLER/////
float Soner[Inn];
int tilstand = 0;
int TilstandSjekk(int, int);
volatile bool running = true;
volatile bool admin = false;
string password = ("admin");
string keyinput;
//volatile int Klokke = 0;
//nt Tid = 0;

/////FUNKSJON DEKLARASJONER/////
void Alarmf();
Thread Alarm;
Thread Sone;
int Tilstandssjekk();
void admin_access_granted();
void sone_monitor();
void password_check();
//void read_keyinput();
//void Alarm();
//Ticker AlarmBlink; // 10Hz blinking for alarmfunksjon på lys og telling


/////MAIN/////
int main()
{
    while(1) {
        if(admin == false) {
            password_check();
        }
        while(admin) {
            Alarm.start(Alarmf);
            sone_monitor();
            read_keyinput();
        }//if-end
    }//main-end
}



/////FUNKSJONER/////
void Alarmf(void)
{
    while(1) {
        if(running == true) {
            Driftslys = !Driftslys;
            Thread::wait(50);
        } else {
            Driftslys = 1;
        }
    }
}

int TilstandSjekk(int i, int tilstand)
{
    if(tilstand == 0) {
        //pc.printf("Vi er i funksjonen normaldrift i sone: %d \n", i);
        //AlarmBlink.detach();
        running = false;
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if ( Y == AlarmUtganger1) AlarmUtganger1 = AlarmUtganger1 - Y;
        if ( Y == AlarmUtganger2) AlarmUtganger2 = AlarmUtganger2 - Y;
        int Utganger1 = AlarmUtganger1;
        int Utganger2 = AlarmUtganger2;
        //pc.printf("Utgangsbuss1 har naa verdien: %d \n Utgangsbuss2 har naa verdien: %d", Utganger1, Utganger2);
    }
    if(tilstand == 1) { //Hvis dør 1 er åpen...
        //pc.printf("Vi er i funksjonen tilstandssjekk dor 1, med verdi: %d\n", i);
        //Alarm();
        running = true;
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y == AlarmUtganger2 ) AlarmUtganger2 = AlarmUtganger2 - Y;
        if( Y!=AlarmUtganger1) AlarmUtganger1 = Y + AlarmUtganger1; //Sjekk om denne verdien har blitt sjekket før, hvis ikke starter alarm på neste dør.
        int Utganger1 = AlarmUtganger1;
        //pc.printf("Vi har verdien paa utgangsbuss: %d\n", Utganger1);
    }
    if(tilstand == 2) { //Hvis dør 2 er åpen...
        //pc.printf("Vi er i funksjonen tilstandssjekk dor 2, med verdi: %d\n", i);
        //Alarm();
        running = true;
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y == AlarmUtganger1 ) AlarmUtganger1 = AlarmUtganger1 - Y;
        if( Y!=AlarmUtganger2) AlarmUtganger2 = Y + AlarmUtganger2;  //Sjekk om denne verdien har blitt sjekket før, hvis ikke starter alarm på neste dør.
        int Utganger2 = AlarmUtganger2;
        //pc.printf("Vi har verdien paa utgangsbuss: %d\n", Utganger2);
    }
    if(tilstand == 3) { //Hvis begge dører er åpne
        //pc.printf("Vi er i funksjonen tilstandssjekk alle dorer, med verdi: %d \n", i);;
        // Alarm();
        running = true;
        double n = 2; // We want 2^i
        double Y = 1;
        for(int k=1; k<=i; k++) Y = Y*n;
        if( Y!=AlarmUtganger1 ) AlarmUtganger1 = Y + AlarmUtganger1;
        if( Y!=AlarmUtganger2 ) AlarmUtganger2 = Y + AlarmUtganger2;
        int Utganger2 = AlarmUtganger2;
        int Utganger1 = AlarmUtganger2;
        //pc.printf("Utgangsbuss1 har verdien: %d \n Utgangsbuss2 har verdien: %d \n", Utganger1, Utganger2);
    }
    return 0;
}
void sone_monitor()
{
    Soner[0] = _Sone1;
    //Soner[1] = _Sone2;
    //Soner[2] = _Sone3;
    //Soner[3] = _Sone4;
    for(int i=0; i < Inn; i++) {
        read_keyinput(i);
        //pc.printf("%f\n", Soner[i]);
        if((Soner[i] > 0.75 )&&( Soner[i] < 0.83)) { //Tilstand1, Dør 1 åpen
            //pc.printf("Vi er i Tilstand1\n");
            tilstand = 1;
            TilstandSjekk(i, tilstand);
        }
        if((Soner[i] > 0.55 )&&( Soner[i] < 0.59)) { //Normaldrift
            //pc.printf("Vi er i Normaldrift\n")
            tilstand = 0;
            TilstandSjekk(i, tilstand);
        }
        if((Soner[i] > 0.65 )&&( Soner[i] < 0.69)) { //Tilstand 2, Dør 2 åpen
            //pc.printf("Vi er i tilstand2\n");
            tilstand = 2;
            TilstandSjekk(i, tilstand);
        }
        if(Soner[i] >= 1) { //Begge dører er åpne
            //pc.printf("Vi er i tilstand 3, begge doorer er aapne");
            tilstand = 3;
            TilstandSjekk(i, tilstand);
        }
        //wait(1.5);
    }
    //pc.printf("%f\n", Sone1[]);
    //Tilstandssjekk(Sone1[]);
    //float volt = Sone1[];
    //pc.printf("%f\n", volt);
    //while(sysclock == 1);
    //while(sysclock == 0);
    //Tid++;
}
void admin_access_granted()
{
    admin = true;
    pc.printf("Admin access granted\n");//info
    pc.printf("Folgende kommandoer kan brukes: \n");// liste over funksjoner tilgjenglig.
    pc.printf("Status sone og dor(sone forst, dor etter) Kommando: 1,2 \n");// funksjon 1 - request spesific status
    pc.printf("Status alle soner og dorer. Kommando: Status \n");// funksjon 1 - request status all
    pc.printf("Reset hele systemet. Kommando: 'Reset' \n");// funksjon 4 - request log all
}
void password_check()
{
    if(pc.readable() == 1) {
        pc.printf("Write password: ");
        string b;
        char s;
        for(int i = 0; i < 5; i++) {
            s = pc.getc();
            pc.printf("%c", s);
            b += s;
            if(b == password) {
                admin_access_granted();
            }
        }
    }
}

void read_keyinput(int i)
{
    if(pc.readable() == 1) {
        pc.printf("Du skriver: ");
        string read;
        char c;
        for(i = 0; i < 6; i++) {
            c = pc.getc();
            pc.printf("%c", c);
            read += c;
            switch(read) {
                case "1, 1":
                    request_status_sone_dor(1, 1);
                    break;
                case "1, 2":
                    request_status_sone_dor(1, 2);
                    break;
                case "2, 1":
                    request_status_sone_dor(2, 1);
                    break;
                case "2, 2":
                    request_status_sone_dor(2, 2);
                    break;
                case "3, 1":
                    request_status_sone_dor(3, 1);
                    break;
                case "3, 2":
                    request_status_sone_dor(3, 2);
                    break;
                case "4, 1":
                    request_status_sone_dor(4, 1);
                    break;
                case "4, 2":
                    request_status_sone_dor(4, 2);
                    break;
                case "Status":
                    request_status();
                    break;
                case "Reset":
                    request_reset();
                    break;
            }
        }
    }
}

void request_status_sone_dor(int sone, int dor)
{
    double n = 2; // We want 2^i
    double Y = 1;
    for(int k=1; k<=sone; k++) Y = Y*n;
    if(dor == 1) {
        if (Alarmutganger1 == Y) pc.printf("Dor: %d i sone: %d er lukket", dor, Y);
        else pc.printf("Dor: %d i sone: %d er apnet", dor, Y);
    }
    if(dor == 2) {
        if (AlarmUtganger2 == Y) pc.printf("Dor: %d i sone: %d er lukket", dor, Y);
        else pc.printf("Dor: %d i sone: %d er apnet", dor, Y);
    }
}

void request_status() {
    int dor1[Inn] = {
    dor1[Inn] = AlarmUtganger2;
    

//BusOut AlarmUtganger1(p21, p22, p23, p24); //1 - Dør 1 Sone 1, 2 - Dør 1 Sone 2, 4 - Dør 1 Sone 3, 8 - Dør 1 Sone 4
//BusOut AlarmUtganger2(p25, p26, p27, p28); //1 - Dør 2 Sone 1, 2 - Dør 2 Sone 2, 4 - Dør 2 Sone 3, 8 - Dør 2 Sone 4