//#include "mbed.h"
#include "ADXL345_I2C.h"

ADXL345_I2C accelerometer(I2C_SDA, I2C_SCL);
Serial pc(SERIAL_TX, SERIAL_RX);
Ticker RAM;
Timer temps;

DigitalIn BTN(USER_BUTTON);
DigitalIn BTNmode(PC_10);
 
int data = 0, j = 0; 

char X[157][64];
uint8_t a, b;
float XYZ[3]; 
bool appui = false, Mode = false;

void dataWrite(){
    if(j == 0) pc.printf("Bouton appuye\n\r");
    if(j < 10000 && appui){
        X[a][b] = (char)XYZ[0];
        if(b < 64){ // 
            b++;    
        }else{  // Page + 1; 
            b = 0;
            a++;    
        }
        j++;
    }else if(appui){
        pc.printf("Ecriture sur la EEPROM\n\r");
        for(a = 0; a < 157; a++){
            char data[66];
            data[0] = 0;
            data[1] = a;
            for(b = 0; b < 64; b++){
                data[b+2] = X[a][b];
            }
            accelerometer.writeEEPROM(data, 66);
            wait(0.01);
            pc.printf("%u : Donnee ecrite\n\r", a);
        }
        pc.printf("Ecriture fini\n\r");
        j = 0;
        RAM.detach();
    }
 }
 
 int main() {
    pc.baud(9600);
    
    int readings[3] = {0, 0, 0};
     
    pc.printf("\n\rStarting ADXL345 test...\n\r");
    pc.printf("Device ID is: 0x%02x\n\r", accelerometer.getDeviceID());
    
    //******* Initialisation ADXL ********//
    // These are here to test whether any of the initialization fails. It will print the failure
    if (accelerometer.setPowerControl(0x00)){
        return 0;  
    }
    wait(.001);
     
    if(accelerometer.setDataFormatControl(0x0B)){
        pc.printf("didn't set data format\n\r");
        return 0;  
    }
    wait(.001);
     
    //Measurement mode.
     
    if(accelerometer.setPowerControl(MeasurementMode)) {
        pc.printf("didn't set the power control to measurement\n\r"); 
        return 0;   
    } 
    //****** FIN INITIALISATION ********//
 
    while (1) {
        //wait(0.1);
        if(!BTN){
            appui = true;
            RAM.attach(&dataWrite, 0.001);     
        }
        accelerometer.getOutput(readings);
        XYZ[0] = readings[0] * 0.004;
        XYZ[1] = readings[1] * 0.004;
        XYZ[2] = readings[2] * 0.004;

        accelerometer.LCDprint(XYZ[0], XYZ[1], XYZ[2]);   // À afficher sur LCD
        //pc.printf("X: %.3fg |   Y: %.3fg        |   Z: %.3fg", XYZ[0],XYZ[1], XYZ[2]);      // Affichage sur un terminal plutot que sur LCD
    
        if(!BTNmode){
             Mode = true;
             temps.start();
             pc.printf("Temps(s)    Accel X(g)      Accel Y(g)      Accel Z(g)");
        }
        
        if(Mode){
            pc.printf("%.3f     %.3f    %.3f    %.3f", temps.read(), XYZ[0], XYZ[1], XYZ[2]);
        }
    }
}

