/*
 * Le 16 decembre 2019
 * Bruno St-Georges et Nicolas Brochu
 * Instrumentation en systemes ordines
 * 
 * Laboratoire 8 - Capteur ultrasonique
 * Ce programme permet de mesurer une distance (mm) ou une vitesse (mm/s) a l'aide d'un capteur ultrasonique.
 * Un bouton-poussoir permet de changer le mode de fonctionnement (correction d'erreur) selon la table suivante:
 * - Mode 0: Correction par plafonnement
 * - Mode 1: Correction par omission des donnees erronees
 * - Mode 2: Correction par extrapolation
 * - Mode 3: Affichage de la vitesse
 *
 * LPC1768
 * Connexions externes:
 * Broche 21 - Bouton-poussoir
 *
 */

// Librairies
#include "mbed.h"
#include "ultrasonic.h"

// Bornes statiques du capteur
#define I_MIN_RANGE 20        // en mm; Integer
#define I_MAX_RANGE 4000      // en mm; Integer

// Variables
uint8_t uiMODECORRECTION = 0;
int iData[5] = {0, 0, 0, 0, 0};
int iI = 0;
int iDISTANCE1, iDISTANCE2, iVITESSE;

// Bouton-poussoir
DigitalIn bouton(p21);

// Fonctions periodiques
Timer t;
Ticker flipper;
void dist(int iDistance)
{
    if(uiMODECORRECTION == 0){              // Plafonnement
        if(iDistance < I_MIN_RANGE){     
            iDistance = I_MIN_RANGE;        // Remplacement par valeur minimale
        }else if(iDistance > I_MAX_RANGE){
            iDistance = I_MAX_RANGE;        // Remplacement par valeur maximale
        }
        printf("Distance %d mm\r\n", iDistance);
    }else if(uiMODECORRECTION == 1){        // Omission des valeurs erronees
        if(!(iDistance < I_MIN_RANGE || iDistance > I_MAX_RANGE)){    // Ignore les valeurs à l'extérieur de la plage
            printf("Distance %d mm\r\n", iDistance);
        }
    }else if(uiMODECORRECTION == 2){        // Extrapolation
        iData[4] = iData[3];    // FIFO pour calcul de variation moyenne
        iData[3] = iData[2];
        iData[2] = iData[1];
        iData[1] = iData[0];
        iData[0] = iDistance;   // Assignation de la valeur presente
        int iVariationMoyenne = ((iData[1] - iData[2]) + (iData[2] - iData[3]) + (iData[3] - iData[4])) / 3;
        if(!(iDistance < I_MIN_RANGE || iDistance > I_MAX_RANGE)){    // Valeurs à l'intérieur de la plage
            printf("Distance %d mm\r\n", iDistance);
        } else {
            iData[0] = iData[1] + iVariationMoyenne;    // Ajoute la variation moyenne a la derniere valeur valide
            printf("Distance %d mm\r\n", iData[0]); 
        }
    }
}

// Objet capteur ultrasonique
ultrasonic sonar(p17, p18, .1, 1, &dist);   // trig, echo, update speed, timeout, fonction a appeler

// Fonction de vitesse
void check(void){
    if(uiMODECORRECTION == 3){
        if(iI == 0){
            iDISTANCE1 = sonar.getCurrentDistance();    
            iI++;
        }
        else if(iI == 1){
            iDISTANCE2 = sonar.getCurrentDistance();    
            iI++;
        }
        else{
            iI = 0;
            iVITESSE = abs(iDISTANCE2 - iDISTANCE1) * 10;   // Vitesse en mm/s
            printf("\n\rVitesse: %i mm/s",iVITESSE);
        }
    }
}
 
// Programme principal
int main(){
    flipper.attach(&check, 0.2);
    sonar.startUpdates(); // Active le capteur
    while(1)
    {
        sonar.checkDistance();  // Mesure de la distance
        if(bouton == 0){        // Choix du mode de fonctionnement
            uiMODECORRECTION++;
            if(uiMODECORRECTION == 4){
                uiMODECORRECTION = 0;
            }
            printf("\n\rMode de correction: %u\n\r",uiMODECORRECTION);
            while(bouton == 0);
            wait_ms(25);
        }
        wait_ms(60);    // Debounce
    }
}
