/*
 * Le 9 decembre 2019
 * Bruno St-Georges et Nicolas Brochu
 * Instrumentation en systemes ordines
 * 
 * Laboratoire 7 - Mesure du pouls
 * Ce programme permet de mesurer un pouls a partir d'un capteur APDS-9008 et d'une DEL ultrabrillante verte.
 * Un montage d'ampli op doit etre realise afin d'obtenir des valeurs de tensions reparties sur l'echelle 0-5V
 * a partir de la sortie du capteur.
 *
 * LPC1768
 * Connexions externes:
 * Broche 16 - Sortie du montage d'ampli op
 *
 */

#include "mbed.h"

// Definition des broches
AnalogIn heartbeat(p16);
DigitalOut LED(LED1);      
DigitalOut DEL(LED2);      

// Port serie 
Serial pc(USBTX, USBRX); // tx, rx

// Timer du temps de battement
Timer t;

// Declaration des variables globales
float temps,tension,bpm;
int bcounter;   // Compteur de battement

// Programme principal
int main() {
    
    pc.printf("\n\rDemarrage du systeme");
    
    while(1) {
        tension = heartbeat.read() * 3.3;
        if(tension > 2.2){              // Detection d'un battement
            t.start();
            while(tension > 1.9){       // hysteresis
                tension = heartbeat.read() * 3.3;
            }
            while(tension < 2.2){       // attente du prochain battement
                tension = heartbeat.read() * 3.3;
            }
            bcounter++;
        }   
        if(bcounter == 5){          // Pour moyenne sur 5 battements de coeur
            bcounter = 0;       
            temps = t.read();       // mesure du temps pris pour 5 battements
            bpm = 5 * 60 / temps;   // Conversion en bpm: * 5 provient de la division du denominateur par 5
            t.reset();              // Remise a zero du timer
            t.stop();
            pc.printf("\n\r%1.0f",bpm);     
        }
    }
}
