

#ifndef ITG3200_H
#define ITG3200_H

/**
 * Includes
 */
#include "mbed.h"

/**
 * Defines
 */
#define ITG3200_DEFAULT_I2C_ADDRESS 0b11010000

//-----------
// Registers
//-----------
#define GYRO_XOUT_H 0x1D
#define GYRO_YOUT_H 0x1F
#define GYRO_ZOUT_H 0x21
#define GYRO_TEMP_H 0x1B

/**
 * ITG3200 digital compass module.
 */
class ITG3200 {

    I2C* i2c;
    int  i2cAddW,i2cAddR;

public:

    /**
     * Constructor.
     *
     * @param sda mbed pin to use for I2C SDA
     * @param scl mbed pin to use for I2C SCL
     * @param address I2C address of this device.
     */
    ITG3200(PinName sda, PinName scl, int i2cAddressW, int i2cAddressR);

    void Init(void);


    /** 
     * Reads the current X-axis rotational rate(roll) of the gyroscope.
     *
     * @return roll integer.
     *         
     */
    int GetX(void);
    
    /**
     * Reads the current Y-axis rotational rate(pitch) of the gyroscope.
     *
     * @return pitch integer.
     *         
     */
    int GetY(void);
    
    /**
     * Reads the current Z-axis rotational rate(yaw) of the gyroscope.
     *
     * @return yaw integer.
     *         
     */
    int GetZ(void);
    
    /**
     * Reads the current temperature of the gyroscope's die.
     *
     * @return temperature integer.
     *         
     */
    int GetTemp(void);

};

#endif /* ITG3200_H */
