
/**
 * Includes
 */
#include "ITG3200.h"

ITG3200::ITG3200(PinName sda, PinName scl, int i2cAddressW, int i2cAddressR) {

    i2c = new I2C(sda, scl);
    // Gyro designed to work at 400KHz. See datasheet for details.
    i2c->frequency(100000);
    i2cAddW = i2cAddressW;
    i2cAddR = i2cAddressR;   

}

void ITG3200::Init(void){
    wait_ms(50);    // Temps necessaire pour le demarrage du gyro     
    char registerNumber[2] = {0x16,0x18};
    char test = 0x3E;
    char registerContents[1] = {};
    i2c->write(i2cAddW, registerNumber, 2);
    
    i2c->write(i2cAddW, &test, 1);
    i2c->read(i2cAddR, registerContents, 1);
    registerContents[0] = registerContents[0] | 0x02;
    i2c->write(i2cAddW, &registerContents[0], 1);
}

int ITG3200::GetX(void){

    char registerNumber = GYRO_XOUT_H;
    char registerContents[2] = {0x00, 0x00};
    
    //First, send the number of register we wish to read,
    //in this case, register numbers 2, 3, which hold the
    //compass bearing as a 16-bit word.
    i2c->write(i2cAddW, &registerNumber, 1);
    
    //Now read two bytes which will be the contents of
    //these registers.
    i2c->read(i2cAddR, registerContents, 2);
    
    //Register 2 [read first], was the high byte, followed by
    //register 3 [read second], which was the low byte.

    return (int16_t)((registerContents[0] << 8) | registerContents[1]);
    
}

int ITG3200::GetY(void){
    
    char registerNumber = GYRO_YOUT_H;
    char registerContents[2] = {0x00, 0x00};
    
    //First, send the number of register we wish to read,
    //in this case, register numbers 2, 3, which hold the
    //compass bearing as a 16-bit word.
    i2c->write(i2cAddW, &registerNumber, 1);
    
    //Now read two bytes which will be the contents of
    //these registers.
    i2c->read(i2cAddR, registerContents, 2);
    
    //Register 2 [read first], was the high byte, followed by
    //register 3 [read second], which was the low byte.

    return (int16_t)((registerContents[0] << 8) | registerContents[1]);

}
    
int ITG3200::GetZ(void){
    
    char registerNumber = GYRO_ZOUT_H;
    char registerContents[2] = {0x00, 0x00};
    
    //First, send the number of register we wish to read,
    //in this case, register numbers 2, 3, which hold the
    //compass bearing as a 16-bit word.
    i2c->write(i2cAddW, &registerNumber, 1);
    
    //Now read two bytes which will be the contents of
    //these registers.
    i2c->read(i2cAddR, registerContents, 2);
    
    //Register 2 [read first], was the high byte, followed by
    //register 3 [read second], which was the low byte.
    
    return (int16_t)((registerContents[0] << 8) | registerContents[1]);

}

int ITG3200::GetTemp(void){
    
    char registerNumber = GYRO_TEMP_H;
    char registerContents[2] = {0x00, 0x00};
    uint16_t temp;
    //First, send the number of register we wish to read,
    //in this case, register numbers 2, 3, which hold the
    //compass bearing as a 16-bit word.
    i2c->write(i2cAddW, &registerNumber, 1);
    
    //Now read two bytes which will be the contents of
    //these registers.
    i2c->read(i2cAddR, registerContents, 2);
    
    //Register 2 [read first], was the high byte, followed by
    //register 3 [read second], which was the low byte.

    temp = (int16_t)((registerContents[0] << 8) | registerContents[1]);
    temp = (temp / 280) - 150;      // 280LSB / °C - offset du capteur
    return temp;

}