#include "mbed.h"
#include "math.h"
#include "string"
#include "sstream"

#define LCD          0x50   // Adresse de LCD
#define LCD_ON       0x41   // Registre pour allumer l'écran
#define LCD_CURSOR   0X45   // Registre de positionnement du curseur
#define LCD_CLEAR    0x51   // Registre pour effacer l'écran
#define LCD_CMD      0xFE   // Registre de commande

AnalogIn analog_value(A0);
I2C i2c(I2C_SDA, I2C_SCL);

int main() {
    i2c.frequency(100000);          // Fréquence du I2C à 100KHz
    
    char commande[4] = {LCD_CMD, LCD_ON, LCD_CMD, LCD_CLEAR};   // Initialise l'écran
    i2c.write(LCD, commande, 4);                                // Initialise l'écran
    
    while(1) {
        float analog = analog_value.read() * 3.3;   // Lecture de la tension sur A0
        
        stringstream ss;                // *** float --> string *** //
        ss << analog;                   // *** float --> string *** //
        string txt = ss.str() + " V";   // *** Composition du string *** //
        
        char data[txt.size() + 3];                  // ******************************** //
        data[0] = LCD_CMD;                          //
        data[1] = LCD_CURSOR;                       //
        data[2] = 0;                                // String --> char +
        for(uint8_t i = 0; i < txt.size(); i++){    // Positionnement du curseur à (0,0)
            data[i + 3] = txt[i];                   //
        }                                           // ******************************** //
        
        i2c.write(LCD, data, txt.size());       // Écriture sur l'écran
    }
}