#include "mbed.h"
 
AnalogIn analog_value(A0);          // Définition broche analogique sur PA_0
Serial pc(SERIAL_TX, SERIAL_RX);    // Définition d'un port série avec l'ordinateur
Ticker printTMP;                    // Définition d'un ticker

uint8_t tmp = 0;        // Définition variable tmp; GLOBAL; tmp = Température

void print(){
    pc.printf("Temperature = %u C", tmp);   // Affiche tmp/température
}

int main() {
    printTMP.attach(&print, 0.2);
    
    while(1) {
        int16_t meas = analog_value.read() * 3300;      // Lecture du port analogique
        tmp = (uint8_t)(((float)meas / 10) - 273.15);   // mV --> °C
    }
}
