#include "mbed.h"
 
SPI spi(PA_7, PA_6, PA_5);  // mosi, miso, sclk
DigitalOut cs(PA_8);        // Chip Select du MCP42010
AnalogIn analog_value(A0);  // Broche PA_0 en mode analogique


int main() {
    spi.format(8,3);            // Mode du SPI
    spi.frequency(1000000);     // Féquence du SPI
    
    while(1) {
        cs = 0;     // Active le MCP42010

        spi.write(0b00010001);      // Indique le registre du PW0 en écriture
     
        spi.write((uint8_t)(analog_value.read() * 255));    // Écrit la valeur souhaité sur PW0

        cs = 1;     // Désactive le MCP42010
    }
}
