#include "mbed.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
  #else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define CNTRL_REG_1 0x2A
#define CNTRL_REG_2 0x2B
#define X_acc 0x01
#define Y_acc 0x03
#define Z_acc 0x05
#define STATUS 0x00

PinName const MOSI = PTD2;
PinName const MISO = PTD3;
PinName const SCK = PTD1;
PinName const SS = PTD0;

float conversion(char buf);

//funzione che trasmette ad uno schermo in SPI i valori delle accelerazioni in codice ascii
void VAL_TO_SPI( char tens, char unit, int pos_unit);

//inizializzazione dell protocollo SPI
SPI device(MOSI, MISO, SCK); // mosi, miso, clock

float x, y, z;

int main(void)
{
    
    I2C i2c(SDA,SCL);
    
    
    //trasmettiamo 8 bit alla volta
    //POL = 0, PHA = 1
    device.format(8,1);
    //frequenza della trasmissione SPI
    device.frequency(500000);
    
    
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    
    int address = MMA8451_I2C_ADDRESS;
   
    char stato=STATUS;
    char addr_reg2=CNTRL_REG_2;
    char data_stato;
    char stato_reg2;
    const char X_addr=X_acc;
    const char Y_addr=Y_acc;
    const char Z_addr=Z_acc;
    char z_buffer;
    char y_buffer;
    char x_buffer;
    char x_str[8];
    char y_str[8];
    char z_str[8];
   //inizializziamo il registro di controllo a 0 per poterlo settare
    char data[2] = {CNTRL_REG_1, 0x00};
    i2c.write(address, data, 2);
    
    //settiamo il registro di controllo
    char data_wr_2[2]={CNTRL_REG_1, 0x3B};
    i2c.write(address,data_wr_2, 2);
   /* 
   //inizializziamo il registro di controllo a 0 per poterlo settare
    char data[2] = {CNTRL_REG_1, 0x00};
    i2c.write(address, data, 2);
    
    
     i2c.write(address,&addr_reg2,1,true);
       i2c.read(address,&stato_reg2,1,false);
    
    char data_reg2[2] = {CNTRL_REG_2, (stato_reg2 |4)};
    i2c.write(address, data_reg2, 2);
    
    settiamo il registro di controllo
    char data_reg1[2]={CNTRL_REG_1, 0xFB};
    i2c.write(address,data_reg1, 2);
*/
    while (true) {
       
       i2c.write(address,&stato,1,true);
       i2c.read(address,&data_stato,1,false);
       
       if(data_stato & 8 == 8)
       {
        z = 0;
        x = 0;
        y = 0;
       i2c.write(address,&Z_addr,1,true);
       i2c.read(address,&z_buffer,1,false);
       
       i2c.write(address,&X_addr,1,true);
       i2c.read(address,&x_buffer,1,false);
       
       i2c.write(address,&Y_addr,1,true);
       i2c.read(address,&y_buffer,1,false);
       
       x = conversion(x_buffer);
       x = x*2.551 + 50;
       sprintf(x_str,"%f",x);
       VAL_TO_SPI( x_str[0], x_str[1], 134);
       printf("X = %c %c", 5, 5);
       printf("\r\n");
       
       y = conversion(y_buffer);
       y = y*2.551 + 50;
       sprintf(y_str,"%f",y);
       VAL_TO_SPI( y_str[0], y_str[1], 132);
       printf("Y = %c %c", 5, 5);
       printf("\r\n");
       
     //  z = conversion(z_buffer);
     //  z = z*2.551 + 50;
     //  sprintf(z_str,"%f",z);
     //  VAL_TO_SPI( z_str[0], z_str[1], 130);
     //  printf("Z = %c %c", z_str[0], z_str[1]);
     //  printf("\r\n");
        
       }
       
       
       
       
       
        
    }
}

  
float conversion(char buf)
{
    float val=0;
    if( (buf/128) >= 1)
       {
            buf -= 128; 
            val -= 128;  
        }
       
       if( (buf/64) >= 1)
       {
            buf-= 64;
            val += 64;
       }
       if( (buf/32) >= 1)
       {
            buf -=32;
            val += 32;
       }
       if( (buf/16) >= 1)
       {
            buf -=16;
            val += 16;
       }
       if( (buf/8) >= 1)
       {
            buf -=8;
            val += 8;
       }
       if( (buf/4) >= 1)
       {
            buf -= 4;
            val += 4;
       }
       if( (buf/2) >= 1)
       {
            buf -= 2;
            val += 2;
       }
       if( (buf/1) >= 1)
       {
            val+= 1;
       }
    val = (float) val/6.4;
    return val;
}

void VAL_TO_SPI( char tens, char unit, int pos_unit)
{
    int pos_tens;
    pos_tens = pos_unit + 1;
    DigitalOut  (SS,0);
    device.write(pos_unit);
    device.write(unit);
    DigitalOut  (SS,1);
    DigitalOut  (SS,0);
    device.write(pos_tens);
    device.write(tens);
    DigitalOut  (SS,1);
    return;   
}
