#include "mbed.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
  #else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define CNTRL_REG_1 0x2A
#define CNTRL_REG_2 0x2B
#define CNTRL_REG_3 0x2C
#define CNTRL_REG_4 0x2D
#define X_acc 0x01
#define Y_acc 0x03
#define Z_acc 0x05
#define STATUS 0x00

//funzione di conversione dell'accelerazione da un numero in CA2 al valore espresso in m/s
//viene richiamata per le accelerazioni su ognuno dei tre assi
float conversion(char buf);

int Inter=0;
void isr(){
    Inter=1;
    }
    
int main(void)
{
    //Classe I2C presente nella libreria mbed
    I2C i2c(SDA,SCL);
    
    //Inizializzazione dell'accelerometro configurando pin e l'indirizzo
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    int address = MMA8451_I2C_ADDRESS;
    
    //variabili che ci servono nel programma
    float x, y, z;
    char stato=STATUS;
    char data_stato;
    
    const char X_addr=X_acc;
    const char Y_addr=Y_acc;
    const char Z_addr=Z_acc;
    
    char z_buffer;
    char y_buffer;
    char x_buffer;
    InterruptIn trig(PTA15);

    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    
    //inizializziamo il registro di controllo a 0 per poterlo settare
    char data[2] = {CNTRL_REG_1, 0x00};
    i2c.write(address, data, 2);
    
    char wr_2[2] = {CNTRL_REG_2, 0x04};
    i2c.write(address, wr_2, 2);
    
    char wr_4[2] = {CNTRL_REG_4, 0x01};
    i2c.write(address, wr_4, 2);
    
    char wr_3[2] = {CNTRL_REG_3, 0x02};
    i2c.write(address, wr_3, 2);

    //settiamo il registro di controllo
    char wr_1[2]={CNTRL_REG_1, 0xFB};
    i2c.write(address,wr_1, 2);
    
   

    while (true) {
       
       //Si legge l'indirizzo di stato nell'accelerometro per vedere se ha
       //convertito nuovi valori di accelerazione
       i2c.write(address,&stato,1,true);
       i2c.read(address,&data_stato,1,false);
       
       trig.rise(&isr);
       if(Inter)
       {
        Inter = 0;
        z = 0;
        x = 0;
        y = 0;
       i2c.write(address,&Z_addr,1,true);
       i2c.read(address,&z_buffer,1,false);
       
       i2c.write(address,&X_addr,1,true);
       i2c.read(address,&x_buffer,1,false);
       
       i2c.write(address,&Y_addr,1,true);
       i2c.read(address,&y_buffer,1,false);
       
       //Richiamiamo la funzione di conversione per esprimere i
       //valori letti in float
       x = conversion(x_buffer);
       printf("X= %f\n\r",x);
       
       y = conversion(y_buffer);
       printf("Y= %f\n\r",y);
       
       z = conversion(z_buffer);
       printf("Z= %f\n\r",z);
       
       printf("\n\r");
       
        //Regolo l'accensione dei led per verificare la presenza di accelerazioni
        rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z);
        }
        
        
    }
}


float conversion(char buf)
{
    float val = 0;
    if( (buf/128) >= 1)
       {
            buf -= 128; 
            val -= 128;  
        }
       
       if( (buf/64) >= 1)
       {
            buf-= 64;
            val += 64;
       }
       if( (buf/32) >= 1)
       {
            buf -=32;
            val += 32;
       }
       if( (buf/16) >= 1)
       {
            buf -=16;
            val += 16;
       }
       if( (buf/8) >= 1)
       {
            buf -=8;
            val += 8;
       }
       if( (buf/4) >= 1)
       {
            buf -= 4;
            val += 4;
       }
       if( (buf/2) >= 1)
       {
            buf -= 2;
            val += 2;
       }
       if( (buf/1) >= 1)
       {
            val+= 1;
       }
    val = (float) val*9.8/64;
    return val;
}
