NXP PCT2075 temperature sensor driver for mbed
==============================================

This library is a driver for the [NXP PCT2075](http://www.nxp.com/products/sensors/i2c-temperature-voltage-monitors/ic-bus-fm-plus-1-degree-c-accuracy-digital-temperature-sensor-and-thermal-watchdog:PCT2075).
It only handles the I2C communication with the sensor, it does not handle the OS
interupt line. The [mbed InterruptIn](https://developer.mbed.org/handbook/InterruptIn) library can be used for this.

Example usage:

```
#include <mbed.h>
#include <PCT2075.h>

Serial s(USBTX, USBRX); // tx, rx

InterruptIn TempPinInt(PC4);
LowPowerTicker ticker;

static volatile bool temp_int = false;
static volatile bool tick_int = false;

int main( void )
{
    TempPinInt.mode(PullUp);

    PCT2075::Configuration config = {
        PCT2075::OS_FAULT_QUE_1,
        PCT2075::OS_ACTIVE_LOW,
        PCT2075::OS_MODE_INTERRUPT,
        PCT2075::DEVICE_MODE_SHUTDOWN
    };
    temp_sensor.set_configuration(config);
    temp_sensor.set_idle_time(PCT2075::TIDLE_MAX);
    
    temp_sensor.set_hyst_temperature(2000);
    temp_sensor.set_os_temperature(2500);
    
    TempPinInt.fall(&on_fall);
    ticker.attach(&tick, 2.0);

    while(true) {
        sleep(); // wait to be woken up by ticker or temp sensor

        if (tick_int) {
            s.printf("Tick\r\n");
            config.device_mode = PCT2075::DEVICE_MODE_NORMAL;
            temp_sensor.set_configuration(config);
            tick_int = false;
        }

        if (temp_int) {
            config.device_mode = PCT2075::DEVICE_MODE_SHUTDOWN;
            temp_sensor.set_configuration(config);
            uint16_t t = temp_sensor.read_temperature();
            s.printf("Temperature: %d\r\n", t);
            temp_int = false;
        }
    }
}

```
