#ifndef SETTINGS_H
#define SETTINGs_H
#include "mbed.h"
class Settings
{
    public:
        Settings();
        ~Settings();
        
        void V_SetLeft(bool B_Left);
        void V_SetRight(bool B_Right);
        void V_SetLine(uint32_t I32_Line);
        void V_SetOldLine(uint32_t I32_OldLine);
        void V_SetOK(bool B_OK);
        //void V_SetCounter(uint32_t I32_LineCounter);
        void V_SetOutput1(uint32_t I32_Universe);
        void V_SetOutput2(uint32_t I32_Universe);
        void V_SetOutput3(uint32_t I32_Universe);
        void V_SetMenu(bool B_Menu);
        
        bool B_GetLeft();
        bool B_GetRight();
        bool B_GetOK();
        bool B_GetMenu();
            
        uint32_t I32_GetLine();
        uint32_t I32_GetOutput1();
        uint32_t I32_GetOutput2();
        uint32_t I32_GetOutput3();
        uint32_t I32_GetOldLine();
        
    private:
        uint32_t I32_m_Output1;
        uint32_t I32_m_Output2;
        uint32_t I32_m_Output3;
        uint32_t I32_m_Line;
        uint32_t I32_m_OldLine;
        bool B_m_Left;
        bool B_m_Right;
        bool B_m_OK;
        bool B_m_Menu;
};
#endif

Settings::Settings()
{
    B_m_Left = false;
    B_m_Right = false;
    B_m_OK = false;
    B_m_Menu = false;
    I32_m_Line = 0;
    I32_m_OldLine = 0;
    I32_m_Output1 = 0;
    I32_m_Output2 = 0;
    I32_m_Output3 = 0;
}

Settings::~Settings()
{
    delete &B_m_Right;
    delete &B_m_Left;
    delete &B_m_OK;
    delete &B_m_Menu;
    delete &I32_m_Line;
    delete &I32_m_Output1;
    delete &I32_m_Output2;
    delete &I32_m_Output3;
    delete &I32_m_OldLine;
}

void Settings::V_SetLine(uint32_t I32_Line)
{
    I32_m_Line = I32_Line;
}

void Settings::V_SetMenu(bool B_Menu)
{
    B_m_Menu = B_Menu;
}

void Settings::V_SetOutput1(uint32_t I32_Universe)
{
    I32_m_Output1 = I32_Universe;
}

void Settings::V_SetOutput2(uint32_t I32_Universe)
{
    I32_m_Output2 = I32_Universe;
}

void Settings::V_SetOldLine(uint32_t I32_OldLine)
{
    I32_m_OldLine = I32_OldLine;
}

void Settings::V_SetOutput3(uint32_t I32_Universe)
{
    I32_m_Output3 = I32_Universe;
}

void Settings::V_SetOK(bool B_OK)
{
    B_m_OK = B_OK;
}

void Settings::V_SetLeft(bool B_Left)
{
    B_m_Left = B_Left;   
}

void Settings::V_SetRight(bool B_Right)
{
    B_m_Right = B_Right;
}

bool Settings::B_GetOK()
{
    return B_m_OK;
}

bool Settings::B_GetLeft()
{
    return B_m_Left;
}

bool Settings::B_GetMenu()
{
    return B_m_Menu;
}

bool Settings::B_GetRight()
{
    return B_m_Right;
}

uint32_t Settings::I32_GetLine()
{
    return I32_m_Line;
}

uint32_t Settings::I32_GetOutput1()
{
    return I32_m_Output1;
}

uint32_t Settings::I32_GetOutput2()
{
    return I32_m_Output2;
}

uint32_t Settings::I32_GetOutput3()
{
    return I32_m_Output3;
}

uint32_t Settings::I32_GetOldLine()
{
    return I32_m_OldLine;
}