#ifndef MAIN_H
#define MAIN_H

//#define _CRT_SECURE_NO_WARNINGS

#include "mbed.h"
#include "rtos.h"
#include "stdint.h"
#include "string"
 
#include "DMX.h"
#include "Settings.h"
#include "Screen.h"

#define FIRMWARE "B-01-10"
const string S_Menu[] {"Firmware", "Output 1", "Output 2", "Output 3"};

DMX XLR1(p9, p10);
DMX XLR2(p13, p14);
DMX XLR3(p28, p27);

Settings S;
Screen Sc;
Ethernet eth;

DigitalOut Error1(LED1);
DigitalOut Error2(LED2);
DigitalOut Error4(LED3);
DigitalOut Error8(LED4);


InterruptIn PushButton(p8);
InterruptIn LeftTwist(p7);
InterruptIn RightTwist(p6);

Timeout EnableRotary;

uint32_t I32_CheckHeader(char C_Header[7]);

void V_InterruptMenu();
void V_Right();
void V_Left();
void V_Reset();
void V_DisplayMenu();
void V_DisableRotary();

void V_WriteTxt(uint32_t I32_Kolom, uint32_t I32_Rij, char * C_Tekst);
void V_GeneralTxt(uint32_t I32_Line);

#endif

 



