#include "string.h"
#include "stdint.h"
#include "TextLCD.h"
TextLCD lcd(p25, p24, p23, p22, p21, p26, TextLCD::LCD20x4);

class Screen
{
    public:
        Screen();
        ~Screen();
        
        void V_Printit() const;
        void V_Clear() const;
        void V_SetRij(uint32_t I32_Rij);
        void V_SetKolom(uint32_t I32_Kolom);
        void V_SetTekst(char * C_Tekst);
        
    private:
        uint32_t I32_m_Rij;
        uint32_t I32_m_Kolom;
        char *C_m_Tekst[];
};

Screen::Screen()
{
    this->I32_m_Rij = 0;
    this->I32_m_Kolom = 0;
    *this->C_m_Tekst = "";
    return;
}

Screen::~Screen()
{
    delete &I32_m_Rij;
    delete &I32_m_Kolom;
    delete C_m_Tekst;
    return;
}

void Screen::V_SetRij(uint32_t I32_Rij)
{
    I32_m_Rij = I32_Rij;
}

void Screen::V_SetKolom(uint32_t I32_Kolom)
{
    I32_m_Kolom = I32_Kolom ;
}

void Screen::V_SetTekst(char C_Tekst[])
{
    *C_m_Tekst = C_Tekst;
}

void Screen::V_Printit() const
{
    lcd.locate(I32_m_Kolom, I32_m_Rij);
    lcd.printf(*C_m_Tekst);
}

void Screen::V_Clear() const
{
    lcd.cls();
}