#include "main.h"    

void V_EnableRotary()
{
    RightTwist.rise(&V_Right);
    LeftTwist.rise(&V_Left);
}    

void V_GeneralTxt(uint32_t I32_Line)
{
    Sc.V_Clear();
    char *C_Line=new char[S_Menu[I32_Line].size()+1];
    C_Line[S_Menu[I32_Line].size()] = 0;
    memcpy(C_Line, S_Menu[I32_Line].c_str(), S_Menu[I32_Line].size());
    V_WriteTxt(6, 0, C_Line);
} 

void V_WriteTxt(uint32_t I32_Kolom, uint32_t I32_Rij, char * C_Tekst)
{
    Sc.V_SetRij(I32_Rij);
    Sc.V_SetKolom(I32_Kolom);
    Sc.V_SetTekst(C_Tekst);
    Sc.V_Printit();
}

void V_InterruptMenu()
{
    if(S.B_GetOK() == false)
    {
        S.V_SetOK(true);
    }
    else
    {
        S.V_SetMenu(true);
    }
}

void V_MenuThread(void const *args)
{
    PushButton.rise(&V_InterruptMenu);                                                                      //interrupt bij push op button, rising edge
    RightTwist.rise(&V_Right);
    LeftTwist.rise(&V_Left);   
    
    while(1)
    {
        uint32_t I32_Line;
        I32_Line - S.I32_GetLine();
        if(S.I32_GetOldLine() == I32_Line)
        {
            if(S.B_GetOK() == true)
            {
                switch (I32_Line)
                {
                    case 0:
                    {
                        Sc.V_Clear();
                        V_WriteTxt(6, 1, FIRMWARE);
                    }
                    case 1:
                    {
                        Sc.V_Clear();
                        V_WriteTxt(6, 1, "Output 1:");
                        V_WriteTxt(6, 1, "Universe");
                        while (S.B_GetMenu() == false);
                        {
                            int32_t I32_InputCounter;
                            if(S.I32_GetLine() <= I32_Line - 1)
                            {
                                I32_InputCounter--;
                                if(I32_InputCounter == -1)
                                {
                                    I32_InputCounter = 255;
                                }
                            }
                            else if(S.I32_GetLine() >= I32_Line + 1)
                            {
                                I32_InputCounter++;
                                if(I32_InputCounter == 256)
                                {
                                    I32_InputCounter = 0;
                                }
                            }
                            char C_Buffer [33];
                            sprintf (C_Buffer, "%d", I32_InputCounter);                             //itoa werkt niet, dus sprintf om conversie te maken
                            V_WriteTxt(9, 2, C_Buffer);
                            S.V_SetOutput1(I32_InputCounter);
                            S.V_SetLine(I32_Line);
                        }
                    }
                    case 2:
                    {
                        Sc.V_Clear();
                        V_WriteTxt(6, 1, "Output 2:");
                        V_WriteTxt(6, 1, "Universe");
                        while (S.B_GetMenu() == false);
                        {
                            int32_t I32_InputCounter;
                            if(S.I32_GetLine() <= I32_Line - 1)
                            {
                                I32_InputCounter--;
                                if(I32_InputCounter == -1)
                                {
                                    I32_InputCounter = 255;
                                }
                            }
                            else if(S.I32_GetLine() >= I32_Line + 1)
                            {
                                I32_InputCounter++;
                                if(I32_InputCounter == 256)
                                {
                                    I32_InputCounter = 0;
                                }
                            }
                            char C_Buffer [33];
                            sprintf (C_Buffer, "%d", I32_InputCounter);
                            V_WriteTxt(9, 2, C_Buffer);
                            S.V_SetOutput2(I32_InputCounter);
                            S.V_SetLine(I32_Line);
                        }
                    }
                    case 3:
                    {
                        Sc.V_Clear();
                        V_WriteTxt(6, 1, "Output 3:");
                        V_WriteTxt(6, 1, "Universe");
                        while (S.B_GetMenu() == false);
                        {
                            int32_t I32_InputCounter;
                            if(S.I32_GetLine() == I32_Line - 1)
                            {
                                I32_InputCounter--;
                                if(I32_InputCounter <= -1)
                                {
                                    I32_InputCounter = 255;
                                }
                            }
                            else if(S.I32_GetLine() == I32_Line + 1)
                            {
                                I32_InputCounter++;
                                if(I32_InputCounter >= 256)
                                {
                                    I32_InputCounter = 0;
                                }
                            }
                            char C_Buffer [33];
                            sprintf (C_Buffer, "%d", I32_InputCounter);
                            V_WriteTxt(9, 2, C_Buffer);
                            S.V_SetOutput3(I32_InputCounter);
                            S.V_SetLine(I32_Line);
                        }
                    }
                    default:
                    {
                        Error4 = !Error4;
                        wait_ms(500);
                    }
                }
            }
        }
        else
        {
            V_GeneralTxt(I32_Line);
        }
    }
}

int main() 
{
//    RightTwist.mode(PullUp);
//    LeftTwist.mode(PullUp);

    Thread T_Menu(V_MenuThread);
    
    XLR1.V_Start();
    XLR2.V_Start();
    XLR3.V_Start();
    
    char C_Buf[572];
    uint16_t I16_Universe;
    while(1) 
    {
        int size = eth.receive();   
        if(size > 0) 
        {
            Error2 = 1;
            eth.read(C_Buf, size);
            Error8 = 1;
            if(C_Buf[34] == 0x19 and C_Buf[35] == 0x36 and C_Buf[36] == 0x19 and C_Buf[37] == 0x36)    //Poort checken (6465 = 0x1936 // deel van udp protocol
            {
                Error1 = 1;
                char C_ID[7];
                memcpy(C_ID, &C_Buf[42], 7);
                if(I32_CheckHeader(C_ID) == 0) 
                {                                                                               //Art-Net Header checken
                    if(C_Buf[50] == 0x00 and C_Buf[51]== 0x50) 
                    {                                                                                       //OPcode checken
                        if(C_Buf[52] == 0x00 and C_Buf[53]== 0x0E) 
                        {                                                                                    //Protocol Versie (14) checken
                            // 56/57 = universe
                            I16_Universe = C_Buf[56];
                            I16_Universe = I16_Universe << 8;
                            I16_Universe = I16_Universe & 0xFF00;
                            I16_Universe = I16_Universe + C_Buf[57];

                            uint8_t I8_Values[511];
                            uint32_t I32_Teller;
                            Error4 = 1;
                            if(I16_Universe == S.I32_GetOutput1()) 
                            {
                                memcpy(I8_Values, &C_Buf[60], 512);
                                Error8 = 1;
                                for (I32_Teller = 1; I32_Teller < 512; I32_Teller ++) 
                                {
                                    XLR1.V_PutData(I32_Teller, I8_Values[I32_Teller -1]);
                                    XLR2.V_PutData(I32_Teller, I8_Values[I32_Teller -1]);
                                }
                            }
                            if(I16_Universe == S.I32_GetOutput2()) 
                            {
                                memcpy(I8_Values, &C_Buf[60], 512);
                                for (I32_Teller = 0; I32_Teller < 512; I32_Teller ++) 
                                {
                                    XLR2.V_PutData(I32_Teller, I8_Values[I32_Teller -1]);
                                }
                            }
                            if(I16_Universe == S.I32_GetOutput3()) 
                            {
                                memcpy(I8_Values, &C_Buf[60], 512);
                                for (I32_Teller = 0; I32_Teller < 512; I32_Teller ++) 
                                {
                                    XLR3.V_PutData(I32_Teller, I8_Values[I32_Teller -1]);
                                }
                            } //einde universes
                        } //einde protocol
                    }//einde OPCODE
                }//Einde Artnet
            }//Einde Poort checken
        }//einde if(size...
    }//einde while
}//einde main

void V_Reset()
{
    Sc.V_Clear();
    delete &S;
}

void V_Right()
{
    V_DisableRotary();
    if(S.B_GetLeft() == true)
    {
        uint32_t I32_Count = S.I32_GetLine();
        if(I32_Count == 4)
        {
            I32_Count = 0;
        }
        else
        {
            I32_Count++;
        }
        S.V_SetLine(I32_Count);
    }
    else
    {
        S.V_SetRight(true);
    }
    
    S.V_SetLeft(false);
}

void V_Left()
{
    V_DisableRotary();
    if(S.B_GetRight() == true)
    {
        uint32_t I32_Count = S.I32_GetLine();
        if(I32_Count == 0)
        {
            I32_Count = 4;
        }
        else
        {
            I32_Count--;
        }
        S.V_SetLine(I32_Count);
    }
    else
    {
        S.V_SetLeft(true);
    }
    S.V_SetRight(false);
}

void V_DisableRotary()
{
    RightTwist.rise(NULL);
    LeftTwist.rise(NULL);
    EnableRotary.attach_us(&V_EnableRotary, 5000);                      //na 5 ms intterupts terug enablen
}

uint32_t I32_CheckHeader(char C_Header[6])
{
    if(C_Header[0] == 'A')
    {
        if(C_Header[1] == 'r')
        {
            if(C_Header[2] == 't')
            {
                if(C_Header[3] == '-')
                {
                    if(C_Header[4] == 'N')
                    {
                        if(C_Header[5] == 'e')
                        {
                            if(C_Header[6] == 't')
                            {
                                return 0;
                            }
                            else
                            {
                                return 1;
                            }  
                        }
                        else
                        {
                            return 1;
                        }  
                    }
                    else
                    {
                        return 1;
                    }  
                }
                else
                {
                    return 1;
                }     
            }
            else
            {
                return 1;
            }  
        }
        else
        {
            return 1;
        }    
    }
    else
    {
        return 1;
    }
}
