#include "mbed.h"

#include "mcp3208.h"

SPISlave to_cdh(p5,p6,p7,p8); // mosi, miso, sclk, ssel
Serial pc(USBTX,USBRX);

DigitalOut myleds[4] = {LED1,LED2,LED3,LED4}; // mbed動作目視確認用LED
DigitalOut ADC_on(p21); // ADC用のスイッチをONにするピン
DigitalOut ADC_off(p22); // ADC用のスイッチをOFFにするピン
DigitalOut COM_on(p23);
DigitalOut COM_off(p24);
DigitalOut myled(LED1);

AnalogIn v(p16);
SPI spi(p11,p12,p13);
MCP3208 mcp3208(spi,p14);
DigitalOut dyn(p25);

float v_bat[5], EPS_cur[5], ADC_cur[5], dyn_cur[5];
int data;

int main()
{
    pc.printf("--Hi,this is eps(slave).\r\n");
    
    to_cdh.format(8,3);
    to_cdh.frequency(1000000);

    int sdummy = 0xAA;

    while(1) {

        if(to_cdh.receive()) {
            int rcmd = to_cdh.read();   //receive 1st byte
            int rdummy = to_cdh.read(); //receive 2nd byte
            
            to_cdh.reply(sdummy); // prepare to send 1st byte (dummy)
//            to_cdh.reply(rcmd);
            
            if(rcmd == 0x01){
                to_cdh.reply(rcmd);
            }
            else if(rcmd == 0x02){
                to_cdh.reply(rcmd);
                
                pc.printf("ADC ON \r\n");
                ADC_on = 1;
                wait(0.5);
                ADC_on = 0;
            }
            else if (rcmd == 0x05){
                to_cdh.reply(rcmd);
                pc.printf("start initial sensing\r\n");
                for(int i=0; i<5; i++){
                    v_bat[i] = v.read()*3.3*8.4/3.3;
                    EPS_cur[i] = mcp3208.read_input(0)*5; //()内の数字はchナンバー
                    ADC_cur[i] = mcp3208.read_input(1)*5; //()内の数字はchナンバー
                    pc.printf("bat_v = %f[v] EPS_cur = %f[A] ADC_cur = %f[A]\r\n ",v_bat[i],EPS_cur[i],ADC_cur[i]);
                    wait(1.0);
                }
                pc.printf("finish initial sensing \r\n");
            
            }
            else if(rcmd == 0x07){
               to_cdh.reply(0xF0);
               pc.printf("send initial sensing data\r\n");
            }

            else if(rcmd == 0x08){
                to_cdh.reply(rcmd);
                
                pc.printf("COM ON\r\n");
                COM_on = 1;
                wait(0.5);
                COM_on = 0;
            }                   

            else if(rcmd == 0x11){
                to_cdh.reply(rcmd);
                
                pc.printf("COM OFF\r\n");
                COM_off = 1;
                wait(0.5);
                COM_off = 0;
            }                      
                     
            else if(rcmd == 0x14){
                to_cdh.reply(rcmd);
                
                pc.printf("Check battery voltage\r\n");
                for(int i=0; i<5; i++){
                    v_bat[i] = v.read()*3.3*8.4/3.3; //3.3必要？
                    pc.printf("bat_v = %f[v]\r\n ",v_bat[i]);
                    wait(1.0);
                }
                pc.printf("finish \r\n");                  
            } 
                        
            else if(rcmd == 0x15){
                to_cdh.reply(0xF1);
                pc.printf("Send battery voltage data\r\n");
            } 
                        
            else if(rcmd == 0x16){
                to_cdh.reply(rcmd);
                
                pc.printf("Heatcut ON\r\n");
                dyn = 1;
                for(int i=0; i<5; i++){
                   dyn_cur[i]= mcp3208.read_input(3)*5; //()内の数字はchナンバー
                   pc.printf("dyn_cur = %f[A]\r\n ",dyn_cur[i]);
                   wait(1.0);
                }
                dyn = 0;
                pc.printf("heat cut OFF\r\n");                
            } 
                        
            else if(rcmd == 0x17){
                to_cdh.reply(0xF2);
                pc.printf("Send cell current data\r\n");
            } 
            else{
                to_cdh.reply(0xFF);
            }
                 
            pc.printf("rcmd: %02x, dummy: %02x\r\n",rcmd, rdummy);
            

        }
    }
}