#ifndef __BLE_SERVICE_H__
#define __BLE_SERVICE_H__

class Service
{
public:

    //zmienne uuid do serwisu i charakterystyk
    
//TUTAJ SA ZMIENNE UUID!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    const static uint16_t SERVICE_UUID = 0xA000;
    const static uint16_t UUID = 0xA001;
    const static uint16_t UUID2 = 0xA002;
    const static uint16_t UUID3 = 0xA003;
    const static uint16_t UUID4 = 0xA004;


//TUTAJ JEST ZMIENNY KONSTRUKTOR TWORZACY SERWIS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //konstruktor obiektu Service ze domyslna wartoscia dla charakterystyk
    Service(BLEDevice &_ble, bool initialValueForCharacteristic) :
        ble(_ble), State(UUID, &initialValueForCharacteristic), State2(UUID2, &initialValueForCharacteristic), State3(UUID3, &initialValueForCharacteristic), State4(UUID4, &initialValueForCharacteristic) {
        GattCharacteristic *charTable[] = {&State,&State2,&State3,&State4}; //tablica z charakterystyk
        GattService         Service(SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *)); //tworzenie serwisu z uuid serwisu i tablica charakterystyk
        ble.addService(Service);  //dodawanie serwisu do ble
    }

//TUTAJ SA ZMIENNE FUNKCJE ZWRACAJACE HANDLE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //funkcja zwracajaca Handle pierwszej charakterystyki
    GattAttribute::Handle_t getValueHandle() const {
        return State.getValueHandle();
    }

    //funkcja zwracajaca Handle drugiej charakterystki
    GattAttribute::Handle_t getValueHandle2() const {
        return State2.getValueHandle();
    }

    //funkcja zwracajaca Handle trzeciej charakterystyki
    GattAttribute::Handle_t getValueHandle3() const {
        return State3.getValueHandle();
    }

    //funkcja zwracajaca Handle czwartej charakterystyki
    GattAttribute::Handle_t getValueHandle4() const {
        return State4.getValueHandle();
    }

private:
    BLEDevice                         &ble;  //potrzebna zmienna ble
//TUTAJ SA ZMIENNE CHARAKTERYSTYKI
    ReadWriteGattCharacteristic<bool>  State;   //zmienna 1 charakterystyki ReadWrite
    ReadWriteGattCharacteristic<bool>  State2;  //zmienna 2 charakterystyki ReadWrite
    ReadWriteGattCharacteristic<bool>  State3;  //zmienna 3 charakterystyki ReadWrite
    ReadWriteGattCharacteristic<bool>  State4;  //zmienna 4 charakterystyki ReadWrite
};

#endif /* #ifndef __BLE_SERVICE_H__ */

/*
    INSTRUKCJE
*/
