#include "mbed.h"
#include "ble/BLE.h"
#include "Service.h"

//TUTAJ SA ZMIENNE WYJSCIA !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

//deklaracja wyjsc
DigitalOut led1(LED1, 0);
DigitalOut led2(LED2, 0);
DigitalOut pin1(P0_1, 0);
DigitalOut pin2(P0_2, 0);
DigitalOut pin3(P0_3, 0);
DigitalOut pin4(P0_4, 0);

//TUTAJ JEST ZMIENNA NAZWA URZADZENIA!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
const static char     DEVICE_NAME[] = "PROTOTYPE";  //nazwa urzadzenia ble
static const uint16_t uuid16_list[] = {Service::SERVICE_UUID};  //stworzenie tablicy z uuid serwisu, ktora potem bedziemy rozglaszac

Service *ServicePtr;    //wskaznik wskazujacy na obiekt klasy Service

//gdy urzadzenie rozlaczy sie, od nowa zacznie rozglaszanie
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}

//gdy zostanie zmieniona wartosc charakterystyki wykona sie ta funkcja
void onDataWrittenCallback(const GattWriteCallbackParams *params)
{
    
//TUTAJ SA ZMINNE FUNKCJE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    if (params->handle == ServicePtr->getValueHandle()) {   //gdy zostaje zmieniona charakterystyka 1
        pin1 = *(params->data);
        led1=pin1;
    }
    if (params->handle == ServicePtr->getValueHandle2()) {  //gdy zostaje zmieniona charakterystyka 2
        pin2 = *(params->data);
        led2=pin2;
    }

    if (params->handle == ServicePtr->getValueHandle3()) {  //gdy zostaje zmieniona charakterystyka 3
        pin3 = *(params->data);
    }

    if (params->handle == ServicePtr->getValueHandle4()) {  //gdy zostaje zmieniona charakterystyka 4
        pin4 = *(params->data);
    }
}

void onBleInitError(BLE &ble, ble_error_t error)
{
    //gdy nie uda sie zainicjowac ble

}


void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)    //funkcja po probie zainicjowania ble
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {  //jezeli byl blad to odwoluje do funkcji onBleInitError
        onBleInitError(ble, error);
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);   //przy rozlaczeniu urzadzenia odwoluje sie do funkcji disconnectionCallback
    ble.gattServer().onDataWritten(onDataWrittenCallback);  //przy zmianie charakterystyk przez ble odwoluje sie do funkcji onDataWrittenCallback

//TUTAJ JEST ZMIENNA !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    bool initialValueForCharacteristic = false;     //domyslna wartosc charaterystyk
    ServicePtr = new Service(ble, initialValueForCharacteristic);   //stworzenie obiektu klasy Service

    /* ustawienie rozgloszenia ble */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));   //rozglaszanie tablicy uuid16_list z uuid serwisu
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));       //rozglaszanie nazwy uzadzenia
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);     //bedzie mozliwosc polaczenia sie z urzadzeniem
    ble.gap().setAdvertisingInterval(100);     //interwal miedzy rozgloszeniami
    ble.gap().startAdvertising();
}

int main(void)
{

    BLE &ble = BLE::Instance(); //przypisanie instancji BLE do wskaznika ble
    ble.init(bleInitComplete);  //po probie inicjalizacji ble

    while (ble.hasInitialized()  == false) {
        /* dopoki ble nie zainicjalizowalo sie czekamy w nieskonczonej petli */
    }

    while (true) {
        ble.waitForEvent(); //czekamy na jakiekolwiek wydarzenie zwiazane z ble
    }
}
