/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "ble/DiscoveredCharacteristic.h"
#include "ble/DiscoveredService.h"
#include "ble/ServiceDiscovery.h"
#include "TextLCD/TextLCD.h"

TextLCD lcd(P0_15, P0_16, P0_17, P0_18, P0_19, P0_20); // rs, e, d4-d7
DigitalOut alivenessLED(LED1, 1);

bool                     triggerLedCharacteristic = false;
DiscoveredCharacteristic allState;
DiscoveredService Service;


Ticker ticker;

void periodicCallback(void) {
    alivenessLED = !alivenessLED; /* Do blinky on LED1 while we're waiting for BLE events */
}

void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) {
    if (params->peerAddr[5] != 0xC4) { /* !ALERT! Alter this filter to suit your device. */
        return;
    }
    printf("adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi, params->isScanResponse, params->type);
           printf("len = %u\r\n", params->advertisingDataLen);
    //unsigned index = 0;
    //for (; index < params->advertisingDataLen; index++) {
     //   printf("%02x ", params->advertisingData[index]);
    //}
    //printf("\r\n");

    BLE::Instance().gap().connect(params->peerAddr, Gap::ADDR_TYPE_RANDOM_STATIC, NULL, NULL);
}

void serviceDiscoveryCallback(const DiscoveredService *service) {
    //printf("ss dziala");
    if (service->getUUID().shortOrLong() == UUID::UUID_TYPE_SHORT) {
        printf("S UUID-%x attrs[%u %u]\r\n", service->getUUID().getShortUUID(), service->getStartHandle(), service->getEndHandle());
        printf("ss dziala");
    } else {
        printf("S UUID-");
        const uint8_t *longUUIDBytes = service->getUUID().getBaseUUID();
        for (unsigned i = 0; i < UUID::LENGTH_OF_LONG_UUID; i++) {
            printf("%02x", longUUIDBytes[i]);
        }
        printf(" attrs[%u %u]\r\n", service->getStartHandle(), service->getEndHandle());
        printf("ss dziala");
    }
}

void characteristicDiscoveryCallback(const DiscoveredCharacteristic *characteristicP) {
    printf("  C UUID-%x valueAttr[%u] props[%x]\r\n", characteristicP->getUUID().getShortUUID(), characteristicP->getValueHandle(), (uint8_t)characteristicP->getProperties().broadcast());
    if (characteristicP->getUUID().getShortUUID() == 0x0014) { /* !ALERT! Alter this filter to suit your device. */
        allState        = *characteristicP;
        triggerLedCharacteristic = true;
        //printf("true\n");
    }
}

void discoveryTerminationCallback(Gap::Handle_t connectionHandle) {
    printf("terminated SD for handle %u\r\n", connectionHandle);
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
    if (params->role == Gap::CENTRAL) {
        //printf("asdqwd %d\n",params->handle);
           
            BLE::Instance().gattClient().onServiceDiscoveryTermination(discoveryTerminationCallback);
            BLE::Instance().gattClient().launchServiceDiscovery(params->handle, serviceDiscoveryCallback, characteristicDiscoveryCallback, 0x0010, 0x0014);
    }
}

void triggerToggledWrite(const GattReadCallbackParams *response) {
    //if (response->handle == allState.getValueHandle()) {
//#if DUMP_READ_DATA
        printf("triggerToggledWrite: handle %u, offset %u, len %u\r\n", response->handle, response->offset, response->len);
        //uint8_t bytes[4];
        
        
         
       // printf("przed forem\n");
        for (unsigned index = 0; index < response->len; index++) {
        //    printf("[%02x]",  response->data[index]);
            
        }
        
        uint8_t bytes_manual[4];
  bytes_manual[0] = response->data[0];
  bytes_manual[1] = response->data[1];
  bytes_manual[2] = response->data[2];
  bytes_manual[3] = response->data[3];
  float z = *(float *)&bytes_manual;
  printf("X =  %f\n",z);
          uint8_t bytes_manualy[4];
  bytes_manualy[0] = response->data[5];
  bytes_manualy[1] = response->data[6];
  bytes_manualy[2] = response->data[7];
  bytes_manualy[3] = response->data[8];
  float za = *(float *)&bytes_manualy;
  printf("Y =  %f\n",za);
          uint8_t bytes_manualz[4];
  bytes_manualz[0] = response->data[10];
  bytes_manualz[1] = response->data[11];
  bytes_manualz[2] = response->data[12];
  bytes_manualz[3] = response->data[13];
  float zad = *(float *)&bytes_manualz;
  printf("Z =  %f\n",zad);
  
  lcd.cls();
  lcd.printf("X:%f;Y:%f;Z:%f\r\n",z,za,zad);
        
        printf("\r\n");
//#endif

        //uint8_t toggledValue = response->data[0] ^ 0x1;
        //allState.write(1, &toggledValue);
    //}
}

void triggerRead(const GattWriteCallbackParams *response) {
    if (response->handle == allState.getValueHandle()) {
        allState.read();
    }
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params) {
    printf("disconnected\r\n");
}

/**
 * This function is called when the ble initialization process has failed
 */
void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Initialization error handling should go here */
}

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
 
    ble.gap().onConnection(connectionCallback);
    ble.gap().onDisconnection(disconnectionCallback);

    ble.gattClient().onDataRead(triggerToggledWrite);
    ble.gattClient().onDataWrite(triggerRead);

    ble.gap().setScanParams(500, 400);
    ble.gap().startScan(advertisementCallback);
}

int main(void) {
    //uint8_t s;
    ticker.attach(periodicCallback, 1);

    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);

    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized()  == false) { /* spin loop */ }
    
    
    while (true) {
        if (triggerLedCharacteristic) {
            //printf("dzialaaasdqaw");
                allState.read();
        }
        ble.waitForEvent();
    }
}
