#include "mbed.h"
#include "ble/BLE.h"
#include "MMA8452Q.h"
#include "Service.h"

MMA8452Q accel(P0_0, P0_1, 0x1D); //deklaracja obiektu akcelerometru (P0_0 -> SDA, P0_1 -> SCL, 0x1D -> ID urzadzenia)
Ticker ticker;
float x,y,z; //zmienne do których przypisywane są wartosci odczytu x y z z akcelerometru

const static char     DEVICE_NAME[] = "BLE_Accel"; 
static const uint16_t uuid16_list[] = {Service::SERVICE_UUID};


static Service *ServicePtr;

void f(){    
    /*
    * Odczyt x y z 
    */
    x=accel.readX(); 
    y=accel.readY();
    z=accel.readZ();
    
    /*
    * Update wartosci w charakterystykach x y z i all
    */    
    ServicePtr->updateXState(x);
    ServicePtr->updateYState(y);
    ServicePtr->updateZState(z);
    ServicePtr->updateALLState(x,y,z);
}


void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}

/**
 * This function is called when the ble initialization process has failled
 */
void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Initialization error handling should go here */
}

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);

    /* Setup primary service */
    ServicePtr = new Service(ble);

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(100); /* 1000ms. */
    ble.gap().startAdvertising();

}

int main(void)
{
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    
    accel.init();
    ticker.attach(f,1);
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized()  == false) { /* spin loop */ }
    
    while (true) {
        ble.waitForEvent();
    }
}
