#ifndef __BLE_SERVICE_H__
#define __BLE_SERVICE_H__

class Service {
public:
    const static uint16_t SERVICE_UUID              = 0x0010;
    const static uint16_t X_CHARACTERISTIC_UUID = 0x0011;
    const static uint16_t Y_CHARACTERISTIC_UUID = 0x0012;
    const static uint16_t Z_CHARACTERISTIC_UUID = 0x0013;
    const static uint16_t ALL_CHARACTERISTIC_UUID = 0x0014;

    Service(BLE &_ble) :
        ble(_ble), xState(X_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),yState(Y_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),zState(Z_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),allState(ALL_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&xState,&yState, &zState, &allState};
        GattService         Service(Service::SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(Service);
    }

    /*
    * Update wartosci charakterystyk
    */

    void updateXState(float newState) {
        int length = sizeof(float);
        
        uint8_t bytes[sizeof(float)]; //tablica podzielonego float'a
        
        for(int i = 0; i < length; i++){
            bytes[i] = ((uint8_t*)&newState)[i];
        }
    
        int n = sizeof(bytes) / sizeof(bytes[0]);
        ble.gattServer().write(xState.getValueHandle(), (uint8_t *)&bytes, n); //zapisanie danych do charakterystyki
    }
    
    void updateYState(float newState) {
        int length = sizeof(float);
        
        uint8_t bytes[sizeof(float)];//tablica podzielonego float'a
        
        for(int i = 0; i < length; i++){
            bytes[i] = ((uint8_t*)&newState)[i];
        }
            
        int n = sizeof(bytes) / sizeof(bytes[0]);
        ble.gattServer().write(yState.getValueHandle(), (uint8_t *)&bytes, n); //zapisanie danych do charakterystyki
    }
    
    void updateZState(float newState) {
        int length = sizeof(float);
        
        uint8_t bytes[sizeof(float)];//tablica podzielonego float'a
          
        for(int i = 0; i < length; i++){
            bytes[i] = ((uint8_t*)&newState)[i];
        }
          
        int n = sizeof(bytes) / sizeof(bytes[0]);
        ble.gattServer().write(zState.getValueHandle(), (uint8_t *)&bytes, n); //zapisanie danych do charakterystyki
    }
    
    void updateALLState(float newState,float newStatey,float newStatez) {
        
        int length = 14;
        
        uint8_t bytes[14]; //tablica podzielonych float'ow
        
        /*
        *   dzielenie float'ow x y z do tablicy 
        *   mona bylo zrobic forem ;)
        */
        
        bytes[0] = ((uint8_t*)&newState)[0];
        bytes[1] = ((uint8_t*)&newState)[1];
        bytes[2] = ((uint8_t*)&newState)[2];
        bytes[3] = ((uint8_t*)&newState)[3];
        bytes[4] = 0xff;
        bytes[5] = ((uint8_t*)&newStatey)[0];
        bytes[6] = ((uint8_t*)&newStatey)[1];
        bytes[7] = ((uint8_t*)&newStatey)[2];
        bytes[8] = ((uint8_t*)&newStatey)[3];
        bytes[9] = 0xff;
        bytes[10] = ((uint8_t*)&newStatez)[0];
        bytes[11] = ((uint8_t*)&newStatez)[1];
        bytes[12] = ((uint8_t*)&newStatez)[2];
        bytes[13] = ((uint8_t*)&newStatez)[3];
            
            
        uint16_t n = sizeof(bytes) / sizeof(bytes[0]);
        
        ble.gattServer().write(allState.getValueHandle(), (uint8_t *)&bytes, n); //zapisanie danych do charakterystyki
    }

private:
    BLE                              &ble;
    ReadOnlyGattCharacteristic<float>  xState;
    ReadOnlyGattCharacteristic<float>  yState;
    ReadOnlyGattCharacteristic<float>  zState;
    ReadOnlyArrayGattCharacteristic<uint8_t, 14> allState;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
