/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_SERVICE_H__
#define __BLE_SERVICE_H__

class Service {
public:
    const static uint16_t SERVICE_UUID              = 0x0010;
    const static uint16_t X_CHARACTERISTIC_UUID = 0x0011;
    const static uint16_t Y_CHARACTERISTIC_UUID = 0x0012;
    const static uint16_t Z_CHARACTERISTIC_UUID = 0x0013;
    const static uint16_t ALL_CHARACTERISTIC_UUID = 0x0014;

    Service(BLE &_ble) :
        ble(_ble), xState(X_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),yState(Y_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),zState(Z_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),allState(ALL_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&xState,&yState, &zState, &allState};
        GattService         Service(Service::SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(Service);
    }

    void updateXState(float newState) {
        
        int length = sizeof(float);
        
        uint8_t bytes[sizeof(float)];
          for(int i = 0; i < length; i++){
            bytes[i] = ((uint8_t*)&newState)[i];
            //printf("%x ",bytes[i]);
           // printf("%d;",length);
            }

            
            
            int n = sizeof(bytes) / sizeof(bytes[0]);
            //printf("%d",sizeof(bytes[0]));
        ble.gattServer().write(xState.getValueHandle(), (uint8_t *)&bytes, n);
        
        
        
        //uint8_t *p = (uint8_t*)&newState;

        //for (int i = 0; i < sizeof(newState); i++) printf("wwww 0x%02x ", p[i]);
        //ble.gattServer().write(xState.getValueHandle(), (uint8_t *)&newState, sizeof(newState));
    }
    
    void updateYState(float newState) {
        //ble.gattServer().write(yState.getValueHandle(), (uint8_t *)&newState, sizeof(newState));
        int length = sizeof(float);
        uint8_t bytes[sizeof(float)];
          for(int i = 0; i < length; i++){
            bytes[i] = ((uint8_t*)&newState)[i];
            //printf("%x ",bytes[i]);
            }
            //printf("%d",sizeof(bytes[0]));
            
             int n = sizeof(bytes) / sizeof(bytes[0]);
       ble.gattServer().write(yState.getValueHandle(), (uint8_t *)&bytes, n);
    }
    
    void updateZState(float newState) {
        //ble.gattServer().write(zState.getValueHandle(), (uint8_t *)&newState, sizeof(newState));
        int length = sizeof(float);
        uint8_t bytes[sizeof(float)];
          for(int i = 0; i < length; i++){
            bytes[i] = ((uint8_t*)&newState)[i];
            //printf("%x ",bytes[i]);
            }
            //printf("%d",sizeof(bytes[0]));
             int n = sizeof(bytes) / sizeof(bytes[0]);
        ble.gattServer().write(zState.getValueHandle(), (uint8_t *)&bytes, n);
    }
    
    void updateALLState(float newState,float newStatey,float newStatez) {
        
        int length = 14;
        uint8_t bytes[14];
        
        printf("dane: %f;%f;%f\n",newState, newStatey,newStatez);
        
        /*
          for(int i = 0; i < length; i++){
            if(i<=3){
                bytes[i] = ((uint8_t*)&newState)[i];
                printf("X: %x ",bytes[i]);
            }
            else if(i==4){
                bytes[i] = 0xff;
                printf("P: %x ",bytes[i]);
                }
            else if(i>4&&i<=8){
                bytes[i] = ((uint8_t*)&newStatey)[i];
                printf("Y: %x ",bytes[i]);
                }
            else if(i==9){
                bytes[i] = 0xff;
                printf("P: %x ",bytes[i]);
                }
            else if(i>9&&i<14){
                bytes[i] = ((uint8_t*)&newStatez)[i];
                printf("Z: %x ",bytes[i]);
                }
            }
            */
            
            bytes[0] = ((uint8_t*)&newState)[0];
            bytes[1] = ((uint8_t*)&newState)[1];
            bytes[2] = ((uint8_t*)&newState)[2];
            bytes[3] = ((uint8_t*)&newState)[3];
            bytes[4] = 0xff;
            bytes[5] = ((uint8_t*)&newStatey)[0];
            bytes[6] = ((uint8_t*)&newStatey)[1];
            bytes[7] = ((uint8_t*)&newStatey)[2];
            bytes[8] = ((uint8_t*)&newStatey)[3];
            bytes[9] = 0xff;
            bytes[10] = ((uint8_t*)&newStatez)[0];
            bytes[11] = ((uint8_t*)&newStatez)[1];
            bytes[12] = ((uint8_t*)&newStatez)[2];
            bytes[13] = ((uint8_t*)&newStatez)[3];
            
            for(int i=0;i<length;i++){
                printf("%x ",bytes[i]);
                }
            
             uint16_t n = sizeof(bytes) / sizeof(bytes[0]);
             printf("%d",n);
        
        ble.gattServer().write(allState.getValueHandle(), (uint8_t *)&bytes, n);
    }

private:
    BLE                              &ble;
    ReadOnlyGattCharacteristic<float>  xState;
    ReadOnlyGattCharacteristic<float>  yState;
    ReadOnlyGattCharacteristic<float>  zState;
    ReadOnlyGattCharacteristic<float>  allState;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
