#include "mbed.h"
#include "hcsr04.h"
#include "DS1820.h"


#include "Adafruit_SSD1306.h"
 
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};
 
 
I2CPreInit gI2C(PB_9,PB_8);
 
// an SPI sub-class that provides a constructed default
 
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);


Serial pc(USBTX, USBRX); // tx, rx
Ticker tickerMideDistancia;
unsigned distancia=20;

HCSR04  usensor(D7,D8); //(PinName TrigPin,PinName EchoPin):
DigitalIn finalDer(D2);
DigitalIn finalIzq(D3);
DigitalOut step(D13);
DigitalOut dir(D12);
DigitalOut enable(D11);
DigitalOut  led(LED1);   
DS1820      ds1820(D10);    // substitute PA_9 with actual mbed pin name connected to the DS1820 data pin                             
float       temp = 0;
int contador=0;


enum estados {cerrada, abriendose, cerrandose, abierta};
estados estado;


void mideDistancia()
{
    usensor.start();
}

void paso(int d)
{
    dir=d;
    step=1;
    wait_us(100);   // Este es el cambio de paso
    step=0;
    wait_us(900);  //Este hay que cambiar
}

void estadoCerrada()
{
   
    if( (finalIzq == 1) && contador <3) {
        wait(1.0);
        enable=1;
        estado=abriendose;
       // pc.printf("Distance =%d\n",distancia);
        pc.printf("Final2 pulsado\r\n");
        
       
        //distancia < 5 
    }
    
}

void estadoAbriendose()
{
    //pc.printf("Distance =%d\n",distancia);
    if((finalDer==1)) {
        
        estado=abierta;
        enable=0;
             
    } else  {
        
        paso(1);
        //pc.printf("paso\n");
        
    }
  //  if (distancia<4){
        //estado=cerrandose;
        
       // }
}

void estadoCerrandose(){
     //pc.printf("Distance =%d\n",distancia);
     if((finalIzq==1)) {
        
        estado=cerrada;
        enable=0;
    } else  {
        
        paso(0);
        //pc.printf("paso\n");
        
    }
}

void estadoAbierta()
{
    //pc.printf("Distance =%d\n",distancia);
    //if (finalDer==1) {
        
        
        enable=1;
        estado=cerrandose;
        pc.printf("Final1 pulsado\r\n");
        
    //}
    contador++;
    gOled.clearDisplay();
    gOled.printf("piezas transportadas %d\n",contador);
    gOled.display();
        gOled.setTextCursor(0,0);
}

int main()
{
    pc.baud(115200);
    tickerMideDistancia.attach(&mideDistancia, 0.5);
    estado=cerrada;
     gOled.begin();
    gOled.clearDisplay();
     gOled.printf("Hola\n");
    //pc.printf("Estado cerrada\n");
    
     int  error = 0; 
    pc.baud(115200);
    
    if(ds1820.begin()) {
        while(1) {
            ds1820.startConversion();  // start temperature conversion from analog to digital
            wait(1.0);                 // let DS1820 complete the temperature conversion 
            error = ds1820.read(temp); // read temperature from DS1820 and perform cyclic redundancy check (CRC)
            switch(error) {
            case 0:    // no errors -> 'temp' contains the value of measured temperature
                pc.printf("temp = %3.1f C\r\n", temp);
                break;
            case 1:    // no sensor present -> 'temp' is not updated
                pc.printf("no sensor present\n\r");
                break;
            case 2:    // CRC error -> 'temp' is not updated
                pc.printf("CRC error\r\n");
            } 
            led = !led;
        }
    } else
        pc.printf("No DS1820 sensor found!\r\n");
    
    
    
    
    
    while(1) {
        distancia=usensor.get_dist_cm();
        
        switch ( estado ) {
            case cerrada:
                estadoCerrada();
                break;
            case abriendose:
                estadoAbriendose();
                break;
            case abierta:
                estadoAbierta();
                break;
            case cerrandose:
                estadoCerrandose();
                break;
            default:
                break;
        }
    }
}
