//Include de librerías//
#include "mbed.h"
#include "hcsr04.h"
#include "DS1820.h"
#include "Adafruit_SSD1306.h"
/////////////////////////////

// Configuración pantalla OLED
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PB_9,PB_8);

Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);
//////////////////////////////////////////////

Serial pc(USBTX, USBRX); 

//DECLARACIÓN INPUTS Y OUTPUTS

Ticker tickerMideDistancia;//El lector de distancia esta en desuso aunque este declarado
unsigned distancia=20;     //El lector de distancia esta en desuso aunque este declarado
AnalogIn adc_temp(ADC_TEMP);// Temperatura de CPU
HCSR04  usensor(D7,D8);    //(PinName TrigPin,PinName EchoPin):
DigitalIn finalDer(D2);    //Final de carrera DERECHA
DigitalIn finalIzq(D3);    //Final de carrera IZQUIERDA
DigitalIn boton(D5);       //Boton para iniciar el programa seleccionado
DigitalIn switcher(D9);    //Interruptor para indicar que programa usar
DigitalOut step(D13);      //Variable paso del motor stepper
DigitalOut dir(D12);       //Variable de dirección del motor stepper (1 == derecha, 2== izquierda)
DigitalOut enable(D11);    //Variable enable del motor stepper
DigitalOut  led(LED1);     //Led de output de la tarjeta
DigitalOut myLed1 (D4);    //Indicador programa Taladro seleccionado
DigitalOut myLed2 (D6);    //Indicador programa Transportador de Piezas seleccionado
PwmOut     dirBMotor(A3);  //Motor DC

DS1820      ds1820(D10);   //Sensor de temperatura DS1820 montado sobre el husillo, esta en desuso



float temp = 0;
int contador=0;            //Contador de Piezas e Impactos del Taladro
int FUNCIONAR=0;           //Variable que de comienzo al programa en funcion del boton


int x=0;                   //Variable abilitadora programa Transportador de Piezas, en funcion del interruptor
int y=0;                   //Variable abilitadora programa Taladro, en funcion del interruptor

Timer tiempo;              //Temprizador para las acciones del taladro

enum estados {cerrada, abriendose, cerrandose, abierta}; // Enumeración de los 4 estados del programa
estados estado;


void paso(int d)    //FUNCIÓN PASO DEL MOTOR (Si int d==1, dir=1)
{
    dir=d;
    step=1;
    wait_us(100);   // Cambio de paso
    step=0;
    wait_us(900);  //Este hay que cambiar
}

void estadoCerrada() //Estado "cerrada", posición de inicio y reposo
{
    
    enable=0;
    
    if (x==1) {          //Entrada al PROGRAMA 1:  Transportador de Piezas
        
        if((finalIzq == 1) && (FUNCIONAR==1) && contador==0) {     //Inicio en funcion del Final de Carrera de la Izquierda y del Boton
            
            wait(0.5);                                             //Tiempo de espera para descargar la Pieza
            
            estado=abriendose;

            gOled.clearDisplay();                                  // Mensaje en la pantalla OLED
            gOled.printf("Programa Transporte");
            gOled.display();
            gOled.setTextCursor(0,0);

            }
            
        else if (contador>0){                                      // El contador cuenta los ciclos de transporte realizados, si este es mayor que 3 se detiene y no vuelve a salir a no ser que se pulse el boton de inicio
            
            wait(0.5);                                             //Tiempo de espera para descargar la Pieza
            estado=abriendose;
            
            
            }
    }

    if(y==1) {          //Entrada al Programa: Taladro
        
        if((finalIzq == 1) && (FUNCIONAR==1)) {    //Inicio en funcion del Final de Carrera de la Izquierda y del Boton
        estado=abriendose;
        
        gOled.clearDisplay();                      //Mensaje pantalla OLED
        gOled.printf("Programa Taladro");
        gOled.display();
        gOled.setTextCursor(0,0);
        
        }

       
        else if (contador>0){                      //Una vez se alcanza la posicion para taladrar, el contador es mayor de 0 y no parara/cumplira esta condicion hasta que al final del programa se iguale el contador a 0 
    
        estado=abriendose;   
        
        
            
        }
        
        
        
        tiempo.reset();
        tiempo.start(); 
    }


}

void estadoAbriendose()
{
    enable=1;
    paso(1);

    if(x==1) {          //Entrada al Transportador de Piezas

        if((finalDer==1)) {

            estado=abierta;

            } 
        
        
        else if (FUNCIONAR>1){
            
            estado=abierta;
            
        }
        
            
        else  {
            
            gOled.clearDisplay();


            }
    }


    if(y==1) {          //Entrada al Taladro

        
        
        if(tiempo.read() > 4 ){
        
        contador++;
        estado=abierta;
        
        }
        
        else if ((contador>0)  && (tiempo.read() > 0.6)){
    
        contador++;
        
        estado=abierta; 
        
        }
        

    }


}

void estadoCerrandose()
{
    
    enable=1;
    paso(0);

    if(x==1) {          //Entrada al Transportador de Piezas
        
        if(finalIzq==1 && contador<3 && FUNCIONAR==1) {            //Bucle hasta hasta que el contador alcance 3

            estado=cerrada;
            
        } 
        
        else if ((finalIzq==1)&& contador>2) {       //Cuando el contador alcance 3, se terminara el programa
            
        estado = cerrada;
        contador=0;
        FUNCIONAR=0;  
        
        }
        
        else if ((finalIzq==1) && (FUNCIONAR>1)) {       //
            
        estado = cerrada;
        contador=0;
        FUNCIONAR=0;  
            
            }
        

    }
    
    if (y==1){          //Entrada al Taladro
        
        if((tiempo.read() > 0.6) && contador<7 ){    //Recorrido limitado por tiempo y contador(menor que 7) para taladro
        
        estado=cerrada;
        
        }


        else if ((contador>6)&& (finalIzq==1)){      //Cuando el contador alcance 7 se pulse el final de carrera de la izquierda, se terminara el programa
    
        estado = cerrada;
        contador=0;  
        FUNCIONAR=0;
        
        }
         
    
        
    }

}

void estadoAbierta()
{
        
        enable=0;
        
        
        if(x==1){          //Entrada al Transportador de Piezas
            
            contador++;    //Contador Piezas
            
            
            gOled.clearDisplay();
            gOled.printf("Piezas Transportadas = %d\n",contador);
            gOled.display();
            gOled.setTextCursor(0,0);
            

                }
                
        if (y==1){         //Entrada al Taladro
        
            gOled.clearDisplay();
            gOled.printf("Impactos Taladro = %d\n",contador);
            gOled.printf("temp = %3.1f C\r\n", adc_temp.read()*100);
            gOled.display();
            gOled.setTextCursor(0,0);
            pc.printf("ADC Temp = %f\n", (adc_temp.read()*100));
        
                }            
    
    
    tiempo.reset();
    tiempo.start(); 


    estado=cerrandose;

}




int main()
{
    pc.baud(115200);
    estado=cerrada;
    dirBMotor=0.4;
    gOled.begin();
    gOled.clearDisplay();
    gOled.printf("Hola\n");
    gOled.display();
    ds1820.begin();
        ds1820.startConversion();

    if (boton == 1){
        
        FUNCIONAR=1;
        
        }
    
    
    
    if(x==1) {
        gOled.clearDisplay();
        gOled.printf("Programa: Transporte de Piezas\n");
        gOled.display();
    }

    if(y==1) {
        gOled.clearDisplay();
        gOled.printf("Programa: Taladro\n");
        gOled.display();
    }
    tiempo.reset();

    pc.baud(115200);

    while(1) {    
        
       
        
        if (switcher ==0){       //Programa Transportador de Piezas
            
            y=0;
            x=1;
        
            myLed1=1;   
            myLed2=0;
        
            }
            
        else if (switcher==1){   //Programa Taladro
            
            y=1;
            x=0;
            
            myLed1=0;
            myLed2=1;
            
            }
        
        if (boton==1){
            
            FUNCIONAR++;
        
            }
    

        switch ( estado ) {
            case cerrada:
                estadoCerrada();
                break;
            case abriendose:
                estadoAbriendose();
                break;
            case abierta:
                estadoAbierta();
                break;
            case cerrandose:
                estadoCerrandose();
                break;
            default:
                break;
        }

     

    }

}

