#include "mbed.h"
#include "hcsr04.h"
 
 
 
Serial pc(USBTX, USBRX); // tx, rx
Ticker tickerMideDistancia;
unsigned distancia=20;
 
HCSR04  usensor(D7,D8); //(PinName TrigPin,PinName EchoPin):
DigitalIn finalDer(D2);
DigitalIn finalIzq(D3);
DigitalOut step(D13);
DigitalOut dir(D12);
DigitalOut enable(D11);
 
int contador=0;
Timer tiempo;
 
enum estados {cerrada, abriendose, cerrandose, abierta};
estados estado;
 
 
void mideDistancia()
{
    usensor.start();
}
 
void paso(int d)
{
    dir=d;
    step=1;
    wait_us(100);   // Este es el cambio de paso
    step=0;
    wait_us(1300);  //Este hay que cambiar
}
 
 
 
 
 
void estadoCerrada(){
   
   
    if( (finalIzq == 1) && (finalDer==1)) {
        enable=1;
        estado=abriendose;
        
        }

       
    else if (contador>0){
    
        estado=abriendose;   
        
        
    }
        tiempo.reset();
        tiempo.start(); 
}
 
void estadoAbriendose(){
 
 
 
 
   // pc.printf("Distance =%d\n",distancia);
    if(tiempo.read() > 4 ){
        
        contador++;
        estado=abierta;
        enable=0;
        
        

        
    }
        
    else if ((contador>0)  && (tiempo.read() > 0.6)){
    
        contador++;
        estado=abierta;
        enable=0;   
        
        

             
    }
    else  {
        
        paso(1);    
        
        
    }
}
 
void estadoCerrandose(){



     if((tiempo.read() > 0.6) && contador<7) {
        
        
        estado=cerrada;
        

        
    } 
        

    else if ((contador>6)&& (finalIzq==1)){
    
    estado = cerrada;
    enable = 0; 
    contador=0;  
       
    
    }
    
    

    
    else {
        
        paso(0);
        

        
        }
}
 
void estadoAbierta(){
        
        tiempo.reset();
        tiempo.start(); 

        enable=1;
        estado=cerrandose;
              
    
}
 
int main()
{
    pc.baud(115200);
    tickerMideDistancia.attach(&mideDistancia, 0.5);    
    estado=cerrada;
    tiempo.reset();
    wait(3.0);
    while(1) {
        distancia=usensor.get_dist_cm();
        pc.printf("%d\n",distancia);
        switch ( estado ) {
            case cerrada:
                estadoCerrada();
                break;
            case abriendose:
                estadoAbriendose();
                break;
            case abierta:
                estadoAbierta();
                break;
            case cerrandose:
                estadoCerrandose();
                break;
            default:
                break;
        }
    }
}
 